/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.protocol.DebugLog;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;

public class MemoryMapData
extends LogData {
    protected int pid = 0;
    protected long lowAddr = 0L;
    protected long highAddr = 0L;
    protected String libPath = null;

    @Override
    public MemoryMapData clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected boolean parse(DATime startTime) {
        int msgid;
        super.parse(startTime);
        this.pid = this.getInt();
        this.lowAddr = this.getLong();
        this.highAddr = this.getLong();
        if (DebugLog.isEnabled()) {
            DebugLog.printData1("pid(%d) lowAddr(%x) highAddr(%x) ", this.pid, this.lowAddr, this.highAddr);
        }
        if ((msgid = this.getMsgID()) == 18) {
            this.libPath = this.getString();
            if (DebugLog.isEnabled()) {
                DebugLog.printData0("libPath(%s)", this.libPath);
            }
        }
        if (DebugLog.isEnabled()) {
            DebugLog.printData0("\n", new Object[0]);
        }
        return true;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public long getLowAddr() {
        return this.lowAddr;
    }

    public long getHighAddr() {
        return this.highAddr;
    }

    public String getLibPath() {
        return this.libPath;
    }
}

