/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class EvasProperties
extends HierarchyUIObjectProperties {
    private int[] geometry = new int[4];
    private boolean isFocus;
    private String name;
    private boolean isVisible;
    private int[] color = new int[4];
    private boolean isAntiAlias;
    private double scale;
    private int[] sizeHintMin = new int[2];
    private int[] sizeHintMax = new int[2];
    private int[] sizeHintRequest = new int[2];
    private double[] sizeHintAlign = new double[2];
    private double[] sizeHintWeight = new double[2];
    private int[] padding = new int[4];
    private String renderOp;

    public EvasProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    public int[] getGeometry() {
        return this.geometry;
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.geometry[0] = parser.getInt();
        this.geometry[1] = parser.getInt();
        this.geometry[2] = parser.getInt();
        this.geometry[3] = parser.getInt();
        this.isFocus = parser.getBoolean();
        this.name = parser.getString();
        this.isVisible = parser.getBoolean();
        this.color[0] = parser.getInt();
        this.color[1] = parser.getInt();
        this.color[2] = parser.getInt();
        this.color[3] = parser.getInt();
        this.isAntiAlias = parser.getBoolean();
        this.scale = parser.getFloat();
        this.sizeHintMin[0] = parser.getInt();
        this.sizeHintMin[1] = parser.getInt();
        this.sizeHintMax[0] = parser.getInt();
        this.sizeHintMax[1] = parser.getInt();
        this.sizeHintRequest[0] = parser.getInt();
        this.sizeHintRequest[1] = parser.getInt();
        this.sizeHintAlign[0] = parser.getFloat();
        this.sizeHintAlign[1] = parser.getFloat();
        this.sizeHintWeight[0] = parser.getFloat();
        this.sizeHintWeight[1] = parser.getFloat();
        this.padding[0] = parser.getInt();
        this.padding[1] = parser.getInt();
        this.padding[2] = parser.getInt();
        this.padding[3] = parser.getInt();
        this.renderOp = this.getRenderOpMessage(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("geometry", "[" + this.geometry[0] + ", " + this.geometry[1] + ", " + this.geometry[2] + ", " + this.geometry[3] + "]"));
        properties.add(new PropertyValue("name", this.name));
        properties.add(new PropertyValue("focus", Boolean.toString(this.isFocus)));
        properties.add(new PropertyValue("visible", Boolean.toString(this.isVisible)));
        properties.add(new PropertyValue("color", "[" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ", " + this.color[3] + "]"));
        properties.add(new PropertyValue("antiAlias", Boolean.toString(this.isAntiAlias)));
        properties.add(new PropertyValue("scale", Double.toString(this.scale)));
        properties.add(new PropertyValue("sizeHintMin", "[" + this.sizeHintMin[0] + ", " + this.sizeHintMin[1] + "]"));
        properties.add(new PropertyValue("sizeHintMax", "[" + this.sizeHintMax[0] + ", " + this.sizeHintMax[1] + "]"));
        properties.add(new PropertyValue("sizeHintRequest", "[" + this.sizeHintRequest[0] + ", " + this.sizeHintRequest[1] + "]"));
        properties.add(new PropertyValue("sizeHintAlign", "[" + this.sizeHintAlign[0] + ", " + this.sizeHintAlign[1] + "]"));
        properties.add(new PropertyValue("sizeHintWeight", "[" + this.sizeHintWeight[0] + ", " + this.sizeHintWeight[1] + "]"));
        properties.add(new PropertyValue("sizeHintPadding", "[" + this.padding[0] + ", " + this.padding[1] + ", " + this.padding[2] + ", " + this.padding[3] + "]"));
        properties.add(new PropertyValue("renderOp", this.renderOp));
        return properties;
    }

    public String getName() {
        return this.name;
    }

    private String getRenderOpMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_RENDER_BLEND";
            }
            case 1: {
                return "EVAS_RENDER_BLEND_REL";
            }
            case 2: {
                return "EVAS_RENDER_COPY";
            }
            case 3: {
                return "EVAS_RENDER_COPY_REL";
            }
            case 4: {
                return "EVAS_RENDER_ADD";
            }
            case 5: {
                return "EVAS_RENDER_ADD_REL";
            }
            case 6: {
                return "EVAS_RENDER_SUB";
            }
            case 7: {
                return "EVAS_RENDER_SUB_REL";
            }
            case 8: {
                return "EVAS_RENDER_TINT";
            }
            case 9: {
                return "EVAS_RENDER_TINT_REL";
            }
            case 10: {
                return "EVAS_RENDER_MASK";
            }
            case 11: {
                return "EVAS_RENDER_MUL";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    public String toString() {
        String message = "\n[evas_geometry] : [" + this.geometry[0] + ", " + this.geometry[1] + ", " + this.geometry[2] + ", " + this.geometry[3] + "]";
        message = String.valueOf(message) + "\n[evas_focus] : " + this.isFocus;
        message = String.valueOf(message) + "\n[evas_name] : " + this.name;
        message = String.valueOf(message) + "\n[evas_visible] : " + this.isVisible;
        message = String.valueOf(message) + "\n[evas_color] : [" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + ", " + this.color[3] + "]";
        message = String.valueOf(message) + "\n[evas_anti_alias] : " + this.isAntiAlias;
        message = String.valueOf(message) + "\n[evas_scale] : " + this.scale;
        message = String.valueOf(message) + "\n[evas_size_hint_min] : [" + this.sizeHintMin[0] + ", " + this.sizeHintMin[1] + "]";
        message = String.valueOf(message) + "\n[evas_size_hint_max] : [" + this.sizeHintMax[0] + ", " + this.sizeHintMax[1] + "]";
        message = String.valueOf(message) + "\n[evas_size_hint_request] : [" + this.sizeHintRequest[0] + ", " + this.sizeHintRequest[1] + "]";
        message = String.valueOf(message) + "\n[evas_size_hint_align] : [" + this.sizeHintAlign[0] + ", " + this.sizeHintAlign[1] + "]";
        message = String.valueOf(message) + "\n[evas_size_hint_weight] : [" + this.sizeHintWeight[0] + ", " + this.sizeHintWeight[1] + "]";
        message = String.valueOf(message) + "\n[evas_size_hint_padding] : [" + this.padding[0] + ", " + this.padding[1] + ", " + this.padding[2] + ", " + this.padding[3] + "]";
        message = String.valueOf(message) + "\n[evas_render_op] : " + this.renderOp;
        return message;
    }
}

