/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class EvasTextProperties
extends HierarchyUIObjectProperties {
    private String font;
    private int fontSize;
    private String text;
    private String bidiDelimiters;
    private double ellipsis;
    private String style;
    private int[] shadowColor = new int[4];
    private int[] glowColor = new int[4];
    private int[] glow2Color = new int[4];
    private int[] outlineColor = new int[4];
    private int[] stylePad = new int[4];
    private String direction;

    public EvasTextProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.font = parser.getString();
        this.fontSize = parser.getInt();
        this.text = parser.getString();
        this.bidiDelimiters = parser.getString();
        this.ellipsis = parser.getFloat();
        this.style = this.getStyleMessage(parser.getChar());
        this.shadowColor[0] = parser.getInt();
        this.shadowColor[1] = parser.getInt();
        this.shadowColor[2] = parser.getInt();
        this.shadowColor[3] = parser.getInt();
        this.glowColor[0] = parser.getInt();
        this.glowColor[1] = parser.getInt();
        this.glowColor[2] = parser.getInt();
        this.glowColor[3] = parser.getInt();
        this.glow2Color[0] = parser.getInt();
        this.glow2Color[1] = parser.getInt();
        this.glow2Color[2] = parser.getInt();
        this.glow2Color[3] = parser.getInt();
        this.outlineColor[0] = parser.getInt();
        this.outlineColor[1] = parser.getInt();
        this.outlineColor[2] = parser.getInt();
        this.outlineColor[3] = parser.getInt();
        this.stylePad[0] = parser.getInt();
        this.stylePad[1] = parser.getInt();
        this.stylePad[2] = parser.getInt();
        this.stylePad[3] = parser.getInt();
        this.direction = this.getDirectionMessage(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("font", this.font));
        properties.add(new PropertyValue("fontSize", Integer.toString(this.fontSize)));
        properties.add(new PropertyValue("text", this.text));
        properties.add(new PropertyValue("bidiDelimiters", this.bidiDelimiters));
        properties.add(new PropertyValue("ellipsis", Double.toString(this.ellipsis)));
        properties.add(new PropertyValue("style", this.style));
        properties.add(new PropertyValue("shadowColor", "[" + this.shadowColor[0] + ", " + this.shadowColor[1] + ", " + this.shadowColor[2] + ", " + this.shadowColor[3] + "]"));
        properties.add(new PropertyValue("glowColor", "[" + this.glowColor[0] + ", " + this.glowColor[1] + ", " + this.glowColor[2] + ", " + this.glowColor[3] + "]"));
        properties.add(new PropertyValue("glow2Color", "[" + this.glow2Color[0] + ", " + this.glow2Color[1] + ", " + this.glow2Color[2] + ", " + this.glow2Color[3] + "]"));
        properties.add(new PropertyValue("outlineColor", "[" + this.outlineColor[0] + ", " + this.outlineColor[1] + ", " + this.outlineColor[2] + ", " + this.outlineColor[3] + "]"));
        properties.add(new PropertyValue("stylePad", "[" + this.stylePad[0] + ", " + this.stylePad[1] + ", " + this.stylePad[2] + ", " + this.stylePad[3] + "]"));
        properties.add(new PropertyValue("direction", this.direction));
        return properties;
    }

    @Override
    public String getText() {
        return this.text;
    }

    private String getStyleMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_TEXT_STYLE_PLAIN";
            }
            case 1: {
                return "EVAS_TEXT_STYLE_SHADOW";
            }
            case 2: {
                return "EVAS_TEXT_STYLE_OUTLINE";
            }
            case 3: {
                return "EVAS_TEXT_STYLE_SOFT_OUTLINE";
            }
            case 4: {
                return "EVAS_TEXT_STYLE_GLOW";
            }
            case 5: {
                return "EVAS_TEXT_STYLE_OUTLINE_SHADOW";
            }
            case 6: {
                return "EVAS_TEXT_STYLE_FAR_SHADOW";
            }
            case 7: {
                return "EVAS_TEXT_STYLE_OUTLINE_SOFT_SHADOW";
            }
            case 8: {
                return "EVAS_TEXT_STYLE_SOFT_SHADOW";
            }
            case 9: {
                return "EVAS_TEXT_STYLE_FAR_SOFT_SHADOW";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getDirectionMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_BIDI_DIRECTION_NATURAL";
            }
            case 1: {
                return "EVAS_BIDI_DIRECTION_NEUTRAL";
            }
            case 2: {
                return "EVAS_BIDI_DIRECTION_LTR";
            }
            case 3: {
                return "EVAS_BIDI_DIRECTION_RTL";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

