/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.info;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.info.HierarchyTreeNodeInfoLayout;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.info.HierarchyTreeNodeInfoScreenshotFigure;

public class HierarchyTreeNodeInfoFigure
extends Shape {
    private static final int ARC_SIZE = 26;
    private static final int BALLOON_WIDTH = 180;
    private static final int SCREENSHOT_IMAGE_MARGIN = 6;
    private static final int NAME_HEIGHT = 24;
    private static final int DESCRIPTION_HEIGHT = 16;
    private static final int DESCRIPTION_MARGIN = 4;
    private static final int BALLOON_BOTTOM_MARGIN = 13;
    private static final int BALLOON_TAIL_WIDTH = 22;
    private static final int BALLOON_TAIL_HEIGHT = 12;
    private HierarchyUIObject uiObject;
    private HierarchyTreeNodeInfoScreenshotFigure screenshotFigure;

    public HierarchyTreeNodeInfoFigure(HierarchyUIObject uiObject) {
        this.uiObject = uiObject;
        this.setLayoutManager((LayoutManager)new HierarchyTreeNodeInfoLayout());
        this.screenshotFigure = new HierarchyTreeNodeInfoScreenshotFigure(uiObject);
        this.add((IFigure)this.screenshotFigure);
    }

    protected void fillShape(Graphics gc) {
        FontData[] fontData;
        Rectangle bounds = this.getBounds();
        Rectangle balloonBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - 12);
        gc.setAntialias(1);
        gc.setBackgroundColor(ColorResources.TREEVIEW_NODE_INFO_BG);
        gc.fillRoundRectangle(balloonBounds, 26, 26);
        PointList triangle = new PointList(3);
        triangle.addPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height);
        triangle.addPoint(bounds.x + bounds.width / 2 - 11, bounds.y + balloonBounds.height - 1);
        triangle.addPoint(bounds.x + bounds.width / 2 + 11, bounds.y + balloonBounds.height - 1);
        gc.fillPolygon(triangle);
        int drawX = 0;
        int drawY = 0;
        int imageBoxHeight = this.screenshotFigure.getPreferredSize().height;
        String name = this.uiObject.getName();
        if (name != null && !name.equals("")) {
            fontData = FontResources.UIHIERARCHY_TREE_NODE_INFO_NAME_FONT.getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setHeight(fontData[i].getHeight());
                ++i;
            }
            Font font = new Font((Device)Display.getCurrent(), fontData);
            gc.setFont(font);
            Dimension textExtent = TextUtilities.INSTANCE.getStringExtents(name, font);
            drawX = bounds.x + (bounds.width - textExtent.width) / 2;
            drawY = bounds.y + 12 + imageBoxHeight;
            gc.setForegroundColor(ColorResources.TREEVIEW_NODE_INFO_NAME);
            gc.drawText(name, drawX, drawY);
            font.dispose();
        } else {
            drawX = bounds.x + (bounds.width - ImageResources.NO_NAME.getBounds().width) / 2;
            drawY = bounds.y + 12 + imageBoxHeight;
            gc.drawImage(ImageResources.NO_NAME, drawX, drawY);
        }
        fontData = FontResources.UIHIERARCHY_TREE_NODE_INFO_DESCRIPT_FONT.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontData[i].getHeight());
            ++i;
        }
        Font font = new Font((Device)Display.getCurrent(), fontData);
        gc.setFont(font);
        gc.setForegroundColor(ColorResources.TREEVIEW_NODE_INFO_DESCRIPT);
        String childrenCnt = String.valueOf(Integer.toString(this.uiObject.getNumberOfChildren())) + " children";
        Dimension textExtent = TextUtilities.INSTANCE.getStringExtents(childrenCnt, font);
        drawX = bounds.x + (bounds.width - textExtent.width) / 2;
        drawY = bounds.y + 12 + imageBoxHeight + 24 - (16 - textExtent.height) / 2;
        gc.drawText(childrenCnt, drawX, drawY);
        String address = "0x" + Long.toHexString(this.uiObject.getAddress());
        textExtent = TextUtilities.INSTANCE.getStringExtents(address, font);
        drawX = bounds.x + (bounds.width - textExtent.width) / 2;
        drawY = bounds.y + 12 + imageBoxHeight + 24 + 16 + 4 - (16 - textExtent.height) / 2;
        gc.drawText(address, drawX, drawY);
        font.dispose();
    }

    protected void outlineShape(Graphics graphics) {
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int width = 180;
        int height = 109 + this.screenshotFigure.getPreferredSize().height;
        return new Dimension(width, height);
    }

    public HierarchyTreeNodeInfoScreenshotFigure getScreenshotFigure() {
        return this.screenshotFigure;
    }
}

