/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.util.Timer;
import java.util.TimerTask;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.util.Logger;

public class ScreenshotTimer
extends TimerTask {
    private static Timer screenshotTimer = null;

    public static synchronized void start(int sec) {
        ScreenshotTimer.stop();
        screenshotTimer = new Timer("Periodic screenshot timer");
        screenshotTimer.scheduleAtFixedRate((TimerTask)new ScreenshotTimer(), 1000L, (long)(sec * 1000));
    }

    public static synchronized void stop() {
        if (screenshotTimer != null) {
            screenshotTimer.cancel();
            screenshotTimer = null;
        }
    }

    @Override
    public void run() {
        try {
            if (!DACommunicator.captureScreenshot().isSuccess()) {
                Logger.error((Object)"Failed to capture screenshot");
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.warning((Object)"Interrupted during send screenshot message");
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            Logger.warning((Object)"Message to capture screenshot is not supported by communicator");
        }
    }
}

