/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChartBoard;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemList;

public class StatisticsSortListener
implements Listener {
    private MemoryChartBoard chartBoard = null;
    private Map<String, Map<String, DAChartBoardItem>> itemMap = new HashMap<String, Map<String, DAChartBoardItem>>();

    public StatisticsSortListener(MemoryChartBoard chartBoard) {
        this.chartBoard = chartBoard;
    }

    public void handleEvent(Event event) {
        DAChartBoardItem systemItem;
        if (event.type != 1001 || this.chartBoard == null) {
            return;
        }
        this.itemMap.clear();
        for (MemoryChart chart : this.chartBoard.getMemoryChartList()) {
            String chartName = chart.getChartName();
            String pidStr = Integer.toString(chart.getPid());
            if (!this.itemMap.containsKey(pidStr)) {
                this.itemMap.put(pidStr, new HashMap());
            }
            this.itemMap.get(pidStr).put(chartName, chart.getChartItem());
        }
        DAChartBoardItemList pidList = this.chartBoard.getItemList();
        ArrayList<Integer> pidSortList = new ArrayList<Integer>();
        HashMap libSortMap = new HashMap();
        if (this.itemMap.containsKey("0") && (systemItem = this.itemMap.get("0").get(MemoryPageLabels.MEMORY_CHART_SYSTEM_MEMORY)) != null) {
            pidSortList.add(pidList.indexOf(systemItem));
        }
        GridItem[] gridItemArray = (GridItem[])event.data;
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            DATableDataFormat pidData;
            String pidStr;
            GridItem gridItem = gridItemArray[n2];
            DATableDataFormat data = (DATableDataFormat)gridItem.getData();
            String entryName = this.chartBoard.getChartName((String)data.getData().get(0));
            if (CommonUtil.isNumeric((String)entryName)) {
                if (!this.itemMap.containsKey(entryName)) {
                    Logger.warning((Object)("Charts for PID#" + entryName + " are missing! Nothing to sort."));
                    return;
                }
                DAChartBoardItem pidItem = this.itemMap.get(entryName).get(MemoryPageLabels.MEMORY_CHART_PROCESS_MEMORY);
                if (pidItem != null) {
                    pidSortList.add(pidList.indexOf(pidItem));
                }
                if ((pidItem = this.itemMap.get(entryName).get(MemoryPageLabels.MEMORY_CHART_HEAP_MEMORY)) != null) {
                    pidSortList.add(pidList.indexOf(pidItem));
                }
            } else if (gridItem.getParentItem() != null && CommonUtil.isNumeric((String)(pidStr = (String)(pidData = (DATableDataFormat)gridItem.getParentItem().getData()).getData().get(0)))) {
                if (!this.itemMap.containsKey(pidStr)) {
                    Logger.warning((Object)("Charts for PID#" + pidStr + " are missing! Nothing to sort."));
                    return;
                }
                DAChartBoardItem pidItem = this.itemMap.get(pidStr).get(MemoryPageLabels.MEMORY_CHART_HEAP_MEMORY);
                DAChartBoardItem libItem = this.itemMap.get(pidStr).get(entryName);
                if (pidItem != null && libItem != null) {
                    int libIndex;
                    DAChartBoardItemList libList = pidItem.getChildItemList();
                    if (!libSortMap.containsKey(pidStr)) {
                        libSortMap.put(pidStr, new ArrayList());
                    }
                    if ((libIndex = libList.indexOf(libItem)) >= 0) {
                        ((List)libSortMap.get(pidStr)).add(libIndex);
                    }
                }
            }
            ++n2;
        }
        pidList.reArrangeItem(pidSortList.toArray(new Integer[0]));
        pidList.layout(true, true);
        int i = 0;
        while (i < pidList.getItemSize()) {
            DAChartBoardItem pidItem = pidList.get(i);
            MemoryChart chart = this.chartBoard.getChart(pidItem);
            if (chart.getChartName().equals(MemoryPageLabels.MEMORY_CHART_HEAP_MEMORY)) {
                String pidStr = Integer.toString(chart.getPid());
                DAChartBoardItemList children = pidItem.getChildItemList();
                if (children != null && libSortMap.containsKey(pidStr)) {
                    children.reArrangeItem(((List)libSortMap.get(pidStr)).toArray(new Integer[0]));
                    children.layout(true, true);
                }
            }
            ++i;
        }
    }
}

