/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class ProcessMemoryChart
extends MemoryChart {
    private DAChartSeries vssSeries;
    private DAChartSeries rssSeries;
    private DAChartSeries pssSeries;
    private DAChartSeries threeDSeries;
    private DAChartSeries gemSeries;
    private DAChartBoardItem parentBoardItem;

    public ProcessMemoryChart(String pageID, String chartName, DAChartBoardItem chartBoardItem, DAChart chart) {
        super(pageID, chartName, chartBoardItem, chart);
        this.chartType = -105;
        this.chartIcon = ImageResources.FEATURE_MEM_PROCESS_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_MEM_PROCESS_SMALL_NOR;
        this.vssSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_VSS, 3, ColorResources.CHART_SERIES_PURPLE);
        this.rssSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_RSS, 3, ColorResources.CHART_SERIES_PINK);
        this.pssSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_PSS, 3, ColorResources.CHART_SERIES_RED);
        this.threeDSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_THREED, 3, ColorResources.CHART_SERIES_YELLOW);
        this.gemSeries = new DAChartSeries(TimelineChartLabels.PROCESS_MEMORY_CHART_GEM, 3, ColorResources.CHART_SERIES_YELLOWGREEN);
        if (Global.getProject().getMempsAvailable()) {
            chart.addSeries(this.pssSeries);
            chart.addSeries(this.threeDSeries);
            chart.addSeries(this.gemSeries);
        } else {
            chart.addSeries(this.vssSeries);
            chart.addSeries(this.rssSeries);
            chart.addSeries(this.pssSeries);
        }
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.vssSeries.clear();
        this.rssSeries.clear();
        this.pssSeries.clear();
        this.threeDSeries.clear();
        this.gemSeries.clear();
        if (Global.getProject() == null) {
            return;
        }
        String processName = AnalyzerUtil.getProcessName(this.pid);
        if (processName == null) {
            return;
        }
        Map processDataMap = (Map)dataList.get(1);
        List processData = (List)processDataMap.get(this.pid);
        if (processData == null) {
            return;
        }
        int i = 0;
        while (i < processData.size()) {
            List row = (List)processData.get(i);
            double time = (double)((Long)row.get(ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.index)).longValue() / 1000000.0;
            long vssMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_VIRTUAL.index);
            long rssMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_RESIDENT.index);
            long pssMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_PSS.index);
            if (Global.getProject().getMempsAvailable()) {
                long threeDMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_THREED.index);
                long gemMemory = (Long)row.get(ProcessMemoryDBTable.COLUMN.MEMORY_GEM.index);
                this.pssSeries.addSeriesItem(new DAChartSeriesItem(time, (double)pssMemory, Formatter.toByteFormat(pssMemory)));
                this.threeDSeries.addSeriesItem(new DAChartSeriesItem(time, (double)threeDMemory, Formatter.toByteFormat(threeDMemory)));
                this.gemSeries.addSeriesItem(new DAChartSeriesItem(time, (double)gemMemory, Formatter.toByteFormat(gemMemory)));
            } else {
                this.vssSeries.addSeriesItem(new DAChartSeriesItem(time, (double)vssMemory, Formatter.toByteFormat(vssMemory)));
                this.rssSeries.addSeriesItem(new DAChartSeriesItem(time, (double)rssMemory, Formatter.toByteFormat(rssMemory)));
                this.pssSeries.addSeriesItem(new DAChartSeriesItem(time, (double)pssMemory, Formatter.toByteFormat(pssMemory)));
            }
            ++i;
        }
    }

    @Override
    public void clear() {
    }
}

