/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class SyncEventDBTable
extends DBTable {
    public static final String TABLENAME = "SYNC_EVENT";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.SEQUENCE_NUMBER.name) + "," + COLUMN.SYNC_DATA_ID.name + "," + COLUMN.EVENT_TIME.name + "," + COLUMN.API_TYPE.name + "," + COLUMN.TOOLTIP.name + "," + COLUMN.ERROR_NUMBER.name + "," + COLUMN.SYNC_VALUE.name + "," + COLUMN.BLOCK_END_TIME.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "SYNC_EVENT" + " where ((" + COLUMN.API_TYPE.name + " =  " + 0 + " OR " + COLUMN.API_TYPE.name + " = " + 7 + " OR " + COLUMN.API_TYPE.name + " = " + 8 + " OR " + COLUMN.API_TYPE.name + " = " + 9 + " ) and " + COLUMN.EVENT_TIME.name + " between %s and %s)" + " OR " + " ((" + COLUMN.API_TYPE.name + " =  " + 1 + " OR " + COLUMN.API_TYPE.name + " = " + 2 + " OR " + COLUMN.API_TYPE.name + " = " + 3 + " OR " + COLUMN.API_TYPE.name + " = " + 4 + " OR " + COLUMN.API_TYPE.name + " = " + 5 + " OR " + COLUMN.API_TYPE.name + " = " + 6 + ") AND (" + COLUMN.BLOCK_END_TIME.name + " >= %s AND " + COLUMN.EVENT_TIME.name + " <= %s))";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public SyncEventDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.SYNC_DATA_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.EVENT_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.API_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.TOOLTIP.name, "", "VARCHAR", 256));
        this.addColumn(new DBColumn(COLUMN.ERROR_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.SYNC_VALUE.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.BLOCK_END_TIME.name, "NOT NULL", "BIGINT"));
        this.addIndex(COLUMN.SYNC_DATA_ID.index);
    }

    public List<List<Object>> getSyncEventFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.SYNC_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.SYNC_DATA_ID.index));
                prep.setLong(COLUMN.EVENT_TIME.index + 1, (Long)rowData.get(COLUMN.EVENT_TIME.index));
                prep.setByte(COLUMN.API_TYPE.index + 1, (Byte)rowData.get(COLUMN.API_TYPE.index));
                String tooltipStr = this.clipString((String)rowData.get(COLUMN.TOOLTIP.index), 256, rowData.get(COLUMN.EVENT_TIME.index).toString());
                prep.setString(COLUMN.TOOLTIP.index + 1, tooltipStr);
                prep.setLong(COLUMN.ERROR_NUMBER.index + 1, (Long)rowData.get(COLUMN.ERROR_NUMBER.index));
                prep.setLong(COLUMN.SYNC_VALUE.index + 1, (Long)rowData.get(COLUMN.SYNC_VALUE.index));
                prep.setLong(COLUMN.BLOCK_END_TIME.index + 1, (Long)rowData.get(COLUMN.BLOCK_END_TIME.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(COLUMN.SEQUENCE_NUMBER.index + 1));
            row.add(rs.getInt(COLUMN.SYNC_DATA_ID.index + 1));
            row.add(rs.getLong(COLUMN.EVENT_TIME.index + 1));
            row.add(rs.getByte(COLUMN.API_TYPE.index + 1));
            row.add(rs.getString(COLUMN.TOOLTIP.index + 1));
            row.add(rs.getLong(COLUMN.ERROR_NUMBER.index + 1));
            row.add(rs.getLong(COLUMN.SYNC_VALUE.index + 1));
            row.add(rs.getLong(COLUMN.BLOCK_END_TIME.index + 1));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        SYNC_DATA_ID(1, "SYNC_DATA_ID"),
        EVENT_TIME(2, "EVENT_TIME"),
        API_TYPE(3, "API_TYPE"),
        TOOLTIP(4, "TOOLTIP"),
        ERROR_NUMBER(5, "ERROR_NUMBER"),
        SYNC_VALUE(6, "SYNC_VALUE"),
        BLOCK_END_TIME(7, "BLOCK_END_TIME");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

