/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.List;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class NetworkIOChart
extends TimelineChart {
    private DAChartSeries sendSeries;
    private DAChartSeries receiveSeries;

    public NetworkIOChart(String pageID) {
        super(pageID);
        this.chartType = -111;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.NETWORK_IO_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.NETWORK_IO_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_NETWORKIO_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_NETWORKIO_SMALL_NOR;
        this.sendSeries = new DAChartSeries(TimelineChartLabels.NETWORK_IO_CHART_SERIES_SEND, 1, ColorResources.CHART_SERIES_PURPLE);
        this.receiveSeries = new DAChartSeries(TimelineChartLabels.NETWORK_IO_CHART_SERIES_RECEIVE, 1, ColorResources.CHART_SERIES_PINK);
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard) {
        DAChartBoardItem item = super.createBoardItem(chartBoard);
        this.chart.addSeries(this.sendSeries);
        this.chart.addSeries(this.receiveSeries);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        this.sendSeries.clear();
        this.receiveSeries.clear();
        List data = (List)dataList.get(0);
        int i = 0;
        while (i < data.size()) {
            List row = (List)data.get(i);
            double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            long sendSize = (Long)row.get(SystemDataDBTable.COLUMN.NETWORK_SIZE_SEND.ordinal());
            long receiveSize = (Long)row.get(SystemDataDBTable.COLUMN.NETWORK_SIZE_RECEIVE.ordinal());
            this.sendSeries.addSeriesItem(new DAChartSeriesItem(time, (double)sendSize, Formatter.toByteFormat(sendSize)));
            this.receiveSeries.addSeriesItem(new DAChartSeriesItem(time, (double)receiveSize, Formatter.toByteFormat(receiveSize)));
            ++i;
        }
    }
}

