/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.dlog;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DADlogData;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.IntervalManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;
import org.tizen.sdblib.util.StringUtil;

public class DlogTable
extends DATableComposite {
    private String[] columnNames = new String[]{"Time", "Level", "PID", "TID", "Tag", "Message"};
    private int[] columnSizes = new int[]{70, 50, 60, 60, 80, 600};
    private int[] columnAlignment = new int[]{0x1000000, 0x1000000, 0x1000000, 0x1000000, 16384, 16384};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true};
    private int[] sortTypes = new int[6];
    private List<DADlogData> dlogClone = new ArrayList<DADlogData>();

    public DlogTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.initDlogListeners();
    }

    public boolean initDlogListeners() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                int size = ti.length;
                List<Object> startData = ((DATableDataFormat)ti[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)ti[size - 1].getData()).getData();
                long startTime = (Long)startData.get(0);
                long endTime = (Long)endData.get(0);
                Toolbar.INSTANCE.setDlogSelection(true);
                DlogTable.this.setDlogSelecetionRange(startTime, endTime);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent MouseEvent2) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markertime = (Long)markerData.get(0);
                MarkerManager.INSTANCE.addMarker(markertime);
            }
        });
        return true;
    }

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        if (Global.getProject() == null) {
            return output;
        }
        if (!Global.getProject().isLoadedProject() && !DLogDataManager.getInstance().getDlogKill()) {
            return output;
        }
        List<Object> dlogData = new ArrayList();
        dlogData = DLogDataManager.getInstance().parserDlogs();
        this.dlogClone = dlogData;
        int seqnum = 0;
        for (DADlogData dADlogData : dlogData) {
            ArrayList<String> text = new ArrayList<String>();
            ArrayList<Object> tabledata = new ArrayList<Object>();
            DATableDataFormat TableDataformat = new DATableDataFormat(seqnum++);
            String strTime = Formatter.toTimeFormat(dADlogData.getTime());
            text.add(strTime);
            tabledata.add(this.convertTimeStringToLong(strTime));
            text.add(dADlogData.getLevel());
            tabledata.add(dADlogData.getLevel());
            text.add(dADlogData.getPid());
            try {
                tabledata.add(Integer.parseInt(dADlogData.getPid()));
            }
            catch (Exception exception) {
                tabledata.add(dADlogData.getPid());
            }
            text.add(dADlogData.getTid());
            try {
                tabledata.add(Integer.parseInt(dADlogData.getTid()));
            }
            catch (Exception exception) {
                tabledata.add(dADlogData.getTid());
            }
            text.add(dADlogData.getTag());
            tabledata.add(dADlogData.getTag());
            text.add(dADlogData.getMessage());
            tabledata.add(dADlogData.getMessage());
            TableDataformat.getData().add(tabledata.get(0));
            TableDataformat.getData().add(tabledata.get(1));
            TableDataformat.getData().add(tabledata.get(2));
            TableDataformat.getData().add(tabledata.get(3));
            TableDataformat.getData().add(tabledata.get(4));
            TableDataformat.getData().add(tabledata.get(5));
            TableInput tableInput = new TableInput();
            tableInput.setText(text);
            tableInput.setData(TableDataformat);
            output.add(tableInput);
        }
        return output;
    }

    private void setDlogSelecetionRange(long startTime, long endTime) {
        double startMarkerTime = (double)startTime / 1000000.0;
        double endMarkerTime = (double)endTime / 1000000.0;
        this.clearAllselection();
        TimelineChartView TLchartView = (TimelineChartView)AnalyzerUtil.getView(TimelinePage.pageID, TimelineChartView.class.getName());
        Toolbar.INSTANCE.setChartDragStartTime(startTime);
        Toolbar.INSTANCE.setChartDragEndTime(endTime);
        TLchartView.getChartBoard().setVisibleMiddleTime(startMarkerTime);
        AnalyzerManager.getCurrentPage().updateView();
        IntervalManager.INSTANCE.setSelectionMarkerInterval(startMarkerTime, endMarkerTime);
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(TimelinePage.timelineViewID, startTime, endTime, null, null));
    }

    private long convertTimeStringToLong(String timestring) {
        long timelong = 0L;
        Pattern pattern = Pattern.compile("(\\d+):(\\d{2}).(\\d{3})");
        String[] matches = StringUtil.split((String)timestring, (Pattern)pattern);
        if (matches == null || matches.length != 3) {
            return timelong;
        }
        try {
            long min = Long.parseLong(matches[0]) * 60L * 1000L;
            long sec = Long.parseLong(matches[1]) * 1000L;
            long millsec = Long.parseLong(matches[2]);
            timelong = min + sec + millsec;
            return timelong * 1000L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public void updateTable() {
        this.setScrolltoSelection(Toolbar.INSTANCE.getChartDragStartTime(), Toolbar.INSTANCE.getChartDragEndTime());
        super.updateTable();
        this.selectTablefromChartDrag(Toolbar.INSTANCE.getChartDragStartTime(), Toolbar.INSTANCE.getChartDragEndTime());
    }

    private void selectTablefromChartDrag(long start, long end) {
        if (Toolbar.INSTANCE.getDlogSelection()) {
            return;
        }
        this.table.deselectAll();
        int i = 0;
        while (i < this.table.getItems().length) {
            long diffTime = Long.parseLong(this.dlogClone.get(i).getTime());
            if (diffTime >= start && diffTime <= end) {
                this.table.getItem(i).setBackground(ColorResources.TABLE_CONTENTS_SELECTED_START);
                this.table.getItem(i).setForeground(ColorResources.WHITE);
            } else {
                this.table.getItem(i).setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
            }
            ++i;
        }
    }

    private void setScrolltoSelection(long start, long end) {
        if (Toolbar.INSTANCE.getDlogSelection()) {
            return;
        }
        int i = 0;
        while (i < this.table.getItems().length) {
            long diffTime = Long.parseLong(this.dlogClone.get(i).getTime());
            if (diffTime >= start && diffTime <= end) {
                this.table.getVerticalBar().setSelection(i - 1);
                return;
            }
            ++i;
        }
    }

    private void clearAllselection() {
        int i = 0;
        while (i < this.table.getItems().length) {
            this.table.getItem(i).setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
            this.table.getItem(i).setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            ++i;
        }
    }
}

