/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.tizen.dynamicanalyzer.util.Logger;

public class ZipUtils {
    private static final int COMPRESSION_LEVEL = 8;
    private static final int BUFFER_SIZE = 2048;
    private static final String METADATA = ".metadata";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zip(String sourcePath, String output) throws IOException {
        File sourceFile = new File(sourcePath);
        if (!sourceFile.isFile() && !sourceFile.isDirectory()) {
            Logger.error((Object)("Can't find directory " + sourcePath));
            return false;
        }
        File target = new File(output);
        File tParent = target.getParentFile();
        if (!(tParent.exists() && tParent.isDirectory() || tParent.mkdirs())) {
            Logger.error((Object)("Can't create directory for output file " + output));
            return false;
        }
        if (!output.toLowerCase().endsWith(".zip")) {
            output = String.valueOf(output) + ".zip";
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            FileOutputStream fos = new FileOutputStream(output);
            try {
                try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
                    zos.setLevel(8);
                    ZipUtils.zipEntry(sourceFile, sourcePath, zos);
                    zos.finish();
                }
                if (fos == null) return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void zipEntry(File sourceFile, String sourcePath, ZipOutputStream zos) throws IOException {
        if (sourceFile.isDirectory()) {
            if (sourceFile.getName().equalsIgnoreCase(METADATA)) {
                return;
            }
            File[] fileArray = sourceFile.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                ZipUtils.zipEntry(fileArray[i], sourcePath, zos);
                ++i;
            }
        } else {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));){
                String sFilePath = sourceFile.getPath();
                String zipEntryName = sFilePath.substring(sourcePath.length() + 1, sFilePath.length());
                ZipEntry zentry = new ZipEntry(zipEntryName);
                zentry.setTime(sourceFile.lastModified());
                zos.putNextEntry(zentry);
                byte[] buffer = new byte[2048];
                int cnt = 0;
                while ((cnt = bis.read(buffer, 0, 2048)) != -1) {
                    zos.write(buffer, 0, cnt);
                }
                zos.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(File zipFile, File targetDir, boolean fileNameToLowerCase) throws IOException {
        ZipEntry zentry = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileInputStream fis = new FileInputStream(zipFile);
            try {
                try (ZipInputStream zis = new ZipInputStream(fis);){
                    while ((zentry = zis.getNextEntry()) != null) {
                        String fileNameToUnzip = zentry.getName();
                        if (fileNameToLowerCase) {
                            fileNameToUnzip = fileNameToUnzip.toLowerCase();
                        }
                        File targetFile = new File(targetDir, fileNameToUnzip);
                        if (zentry.isDirectory()) {
                            File childFolder = new File(targetFile.getAbsolutePath());
                            if (childFolder.exists()) continue;
                            childFolder.mkdirs();
                            continue;
                        }
                        File parentFolder = new File(targetFile.getParent());
                        if (!parentFolder.exists()) {
                            parentFolder.mkdirs();
                        }
                        ZipUtils.unzipEntry(zis, targetFile);
                    }
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected static void unzipEntry(ZipInputStream zis, File targetFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = zis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

