/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.common.AboutInfo;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;

public class VersionCommand
extends Command {
    public VersionCommand() {
        super("version", 0, "print information about version");
    }

    @Override
    public ExitCode processCommand(String[] args) {
        String format = "%s\t%s";
        AboutInfo info = AboutInfo.getInstance();
        String version = String.format(format, AnalyzerLabels.ABOUT_DIALOG_DA_VERSION, info.getDAVersion());
        System.out.println(version);
        String buildId = String.format(format, AnalyzerLabels.ABOUT_DIALOG_BUILD_TIME, info.getDABuildID());
        System.out.println(buildId);
        String tizenSite = String.format(format, AnalyzerLabels.ABOUT_DIALOG_TIZEN_SITE, info.getTizenSite());
        System.out.println(tizenSite);
        String releaseNote = String.format(format, AnalyzerLabels.ABOUT_DIALOG_RELEASE_NOTE, info.getReleaseNote());
        System.out.println(releaseNote);
        return ExitCode.EX_SUCCESS;
    }
}

