/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUnaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTIdExpression
extends ASTNode
implements IASTIdExpression,
ICPPASTCompletionContext {
    private static final ICPPASTFieldReference NOT_INITIALIZED = new CPPASTFieldReference();
    private IASTName name;
    private ICPPASTFieldReference fTransformedExpression = NOT_INITIALIZED;

    public CPPASTIdExpression() {
    }

    public CPPASTIdExpression(IASTName name) {
        this.setName(name);
    }

    public CPPASTIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTIdExpression copy(IASTNode.CopyStyle style) {
        CPPASTIdExpression copy = new CPPASTIdExpression(this.name == null ? null : this.name.copy());
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ID_NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 1;
        }
        return 3;
    }

    public IType getExpressionType() {
        IBinding binding = this.name.resolvePreBinding();
        if (binding instanceof CPPFunctionSet) {
            binding = this.name.resolveBinding();
        }
        if (this.checkForTransformation(binding)) {
            return this.fTransformedExpression.getExpressionType();
        }
        try {
            if (binding instanceof IProblemBinding) {
                return new ProblemType(10001);
            }
            if (binding instanceof IType || binding instanceof ICPPConstructor) {
                return new ProblemType(10004);
            }
            if (binding instanceof IEnumerator) {
                ICPPEnumeration enumType;
                IType type = ((IEnumerator)binding).getType();
                if (type instanceof ICPPEnumeration && (enumType = (ICPPEnumeration)type).asScope() == CPPVisitor.getContainingScope(this)) {
                    IType fixedType = enumType.getFixedType();
                    if (fixedType != null) {
                        return fixedType;
                    }
                    return CPPSemantics.INT_TYPE;
                }
                return type;
            }
            if (binding instanceof IVariable) {
                IType t = ExpressionTypes.glvalueType(((IVariable)binding).getType());
                return SemanticUtil.mapToAST(t, this);
            }
            if (binding instanceof IFunction) {
                return SemanticUtil.mapToAST(((IFunction)binding).getType(), this);
            }
            if (binding instanceof ICPPTemplateNonTypeParameter) {
                return ExpressionTypes.prvalueType(((ICPPTemplateNonTypeParameter)binding).getType());
            }
            if (binding instanceof ICPPUnknownBinding) {
                return CPPUnknownClass.createUnnamedInstance();
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return new ProblemType(10004);
    }

    public boolean checkForTransformation(IBinding binding) {
        if (this.fTransformedExpression == NOT_INITIALIZED) {
            IASTNode parent;
            this.fTransformedExpression = null;
            if (this.name instanceof ICPPASTQualifiedName && (parent = this.name.getParent()) instanceof ICPPASTUnaryExpression && ((ICPPASTUnaryExpression)parent).getOperator() == 5) {
                return false;
            }
            if (binding instanceof ICPPMember && !(binding instanceof IType) && !(binding instanceof ICPPConstructor) && !((ICPPMember)binding).isStatic()) {
                ICPPASTFunctionDefinition fdef;
                IBinding methodBinding;
                parent = this.getParent();
                while (parent != null && !(parent instanceof ICPPASTFunctionDefinition)) {
                    parent = parent.getParent();
                }
                if (parent instanceof ICPPASTFunctionDefinition && (methodBinding = (fdef = (ICPPASTFunctionDefinition)parent).getDeclarator().getName().resolvePreBinding()) instanceof ICPPMethod && !((ICPPMethod)methodBinding).isStatic()) {
                    CPPASTName nameDummy = new CPPASTName();
                    nameDummy.setBinding(binding);
                    ASTNode owner = new CPPASTLiteralExpression(4, CharArrayUtils.EMPTY);
                    owner = new CPPASTUnaryExpression(4, (IASTExpression)((Object)owner));
                    this.fTransformedExpression = new CPPASTFieldReference(nameDummy, (IASTExpression)((Object)owner));
                    this.fTransformedExpression.setParent(this.getParent());
                    this.fTransformedExpression.setPropertyInParent(this.getPropertyInParent());
                }
            }
        }
        return this.fTransformedExpression != null;
    }

    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        IBinding binding = this.name.resolvePreBinding();
        if (this.checkForTransformation(binding)) {
            return this.fTransformedExpression.getValueCategory();
        }
        if (binding instanceof ICPPTemplateNonTypeParameter) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        if (binding instanceof IVariable || binding instanceof IFunction) {
            return IASTExpression.ValueCategory.LVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        return CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
    }

    public String toString() {
        return this.name != null ? this.name.toString() : "<unnamed>";
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

