/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SnapshotUtils
extends PlatformObject {
    public static final String PROPERTIES = "properties";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String SET_ENTRY = "setEntry";
    private static final String MAP_ENTRY = "mapEntry";
    private static final String LIST_ENTRY = "listEntry";
    private static final String SET_ATTRIBUTE = "setAttribute";
    private static final String MAP_ATTRIBUTE = "mapAttribute";
    private static final String LIST_ATTRIBUTE = "listAttribute";
    private static final String BOOLEAN_ATTRIBUTE = "booleanAttribute";
    private static final String INT_ATTRIBUTE = "intAttribute";
    private static final String LONG_ATTRIBUTE = "longAttribute";
    private static final String BIG_INTEGER_ATTRIBUTE = "bigIntegerAttribute";
    private static final String STRING_ATTRIBUTE = "stringAttribute";
    private static final String SERIALIZED_ATTRIBUTE = "serializedAttribute";

    public static Element makeXMLFromProperties(Document doc, Map<String, Object> properties) {
        Element rootElement = doc.createElement(PROPERTIES);
        for (String key : properties.keySet()) {
            Object value;
            if (key == null || (value = properties.get(key)) == null) continue;
            Element element = null;
            String valueString = null;
            try {
                if (value instanceof String) {
                    valueString = (String)value;
                    element = SnapshotUtils.createKeyValueElement(doc, STRING_ATTRIBUTE, key, valueString);
                } else if (value instanceof Integer) {
                    valueString = ((Integer)value).toString();
                    element = SnapshotUtils.createKeyValueElement(doc, INT_ATTRIBUTE, key, valueString);
                } else if (value instanceof Long) {
                    valueString = ((Long)value).toString();
                    element = SnapshotUtils.createKeyValueElement(doc, LONG_ATTRIBUTE, key, valueString);
                } else if (value instanceof BigInteger) {
                    valueString = ((BigInteger)value).toString();
                    element = SnapshotUtils.createKeyValueElement(doc, BIG_INTEGER_ATTRIBUTE, key, valueString);
                } else if (value instanceof Boolean) {
                    valueString = ((Boolean)value).toString();
                    element = SnapshotUtils.createKeyValueElement(doc, BOOLEAN_ATTRIBUTE, key, valueString);
                } else if (value instanceof List) {
                    element = SnapshotUtils.createListElement(doc, LIST_ATTRIBUTE, key, (List)value);
                } else if (value instanceof Map) {
                    element = SnapshotUtils.createMapElement(doc, MAP_ATTRIBUTE, key, (Map)value);
                } else if (value instanceof HashSet) {
                    element = SnapshotUtils.createSetElement(doc, SET_ATTRIBUTE, key, (Set)value);
                }
            }
            catch (Exception exception) {}
            if (element == null) {
                try {
                    element = SnapshotUtils.createSerializedElement(doc, SERIALIZED_ATTRIBUTE, key, value);
                }
                catch (IOException e) {
                    EDCDebugger.getMessageLogger().logError("Error adding to snapshot: " + value.toString(), e);
                }
            }
            rootElement.appendChild(element);
        }
        return rootElement;
    }

    protected static Element createKeyValueElement(Document doc, String elementType, String key, String value) {
        Element element = doc.createElement(elementType);
        element.setAttribute(KEY, key);
        element.setAttribute(VALUE, value);
        return element;
    }

    protected static Element createListElement(Document doc, String elementType, String listKey, List<Object> list) {
        Element listElement = doc.createElement(elementType);
        listElement.setAttribute(KEY, listKey);
        for (String string : list) {
            Element element = doc.createElement(LIST_ENTRY);
            element.setAttribute(VALUE, string);
            listElement.appendChild(element);
        }
        return listElement;
    }

    protected static Element createSetElement(Document doc, String elementType, String setKey, Set<Object> set) {
        Element setElement = doc.createElement(elementType);
        setElement.setAttribute(KEY, setKey);
        Element element = null;
        for (Object object : set) {
            element = doc.createElement(SET_ENTRY);
            element.setAttribute(VALUE, (String)object);
            setElement.appendChild(element);
        }
        return setElement;
    }

    protected static Element createSerializedElement(Document doc, String elementType, String key, Object value) throws IOException {
        Element element = doc.createElement(elementType);
        element.setAttribute(KEY, key);
        element.appendChild(doc.createTextNode(SnapshotUtils.serializeObjectToString(value)));
        return element;
    }

    protected static Element createMapElement(Document doc, String elementType, String mapKey, Map<Object, Object> map) {
        Element mapElement = doc.createElement(elementType);
        mapElement.setAttribute(KEY, mapKey);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue() != null ? entry.getValue().toString() : null;
            Element element = doc.createElement(MAP_ENTRY);
            element.setAttribute(KEY, key);
            element.setAttribute(VALUE, value);
            mapElement.appendChild(element);
        }
        return mapElement;
    }

    public static void initializeFromXML(Element root, Map<String, Object> properties) throws CoreException {
        if (root.getNodeName().equalsIgnoreCase(PROPERTIES)) {
            NodeList list = root.getChildNodes();
            Node node = null;
            Element element = null;
            String nodeName = null;
            int i = 0;
            while (i < list.getLength()) {
                node = list.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 1) {
                    element = (Element)node;
                    nodeName = element.getNodeName();
                    try {
                        if (nodeName.equalsIgnoreCase(STRING_ATTRIBUTE)) {
                            SnapshotUtils.setStringAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(INT_ATTRIBUTE)) {
                            SnapshotUtils.setIntegerAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(LONG_ATTRIBUTE)) {
                            SnapshotUtils.setLongAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(BIG_INTEGER_ATTRIBUTE)) {
                            SnapshotUtils.setBigIntegerAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(BOOLEAN_ATTRIBUTE)) {
                            SnapshotUtils.setBooleanAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(LIST_ATTRIBUTE)) {
                            SnapshotUtils.setListAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(MAP_ATTRIBUTE)) {
                            SnapshotUtils.setMapAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(SET_ATTRIBUTE)) {
                            SnapshotUtils.setSetAttribute(element, properties);
                        } else if (nodeName.equalsIgnoreCase(SERIALIZED_ATTRIBUTE)) {
                            SnapshotUtils.setSerializedAttribute(element, properties);
                        } else {
                            EDCDebugger.getMessageLogger().logError("Unsupported element: " + nodeName, null);
                        }
                    }
                    catch (Exception e) {
                        EDCDebugger.getMessageLogger().logError("Skipping snapshot element.", e);
                    }
                }
                ++i;
            }
        }
    }

    protected static void setStringAttribute(Element element, Map<String, Object> properties) throws CoreException {
        properties.put(element.getAttribute(KEY), element.getAttribute(VALUE));
    }

    protected static void setIntegerAttribute(Element element, Map<String, Object> properties) throws CoreException {
        properties.put(element.getAttribute(KEY), new Integer(element.getAttribute(VALUE)));
    }

    protected static void setLongAttribute(Element element, Map<String, Object> properties) throws CoreException {
        properties.put(element.getAttribute(KEY), new Long(element.getAttribute(VALUE)));
    }

    protected static void setSerializedAttribute(Element element, Map<String, Object> properties) throws CoreException, IOException, ClassNotFoundException, DecoderException {
        properties.put(element.getAttribute(KEY), SnapshotUtils.createSerializedObjectFromString(element.getFirstChild().getTextContent()));
    }

    protected static void setBigIntegerAttribute(Element element, Map<String, Object> properties) throws CoreException {
        properties.put(element.getAttribute(KEY), new BigInteger(element.getAttribute(VALUE)));
    }

    protected static void setBooleanAttribute(Element element, Map<String, Object> properties) throws CoreException {
        properties.put(element.getAttribute(KEY), Boolean.valueOf(element.getAttribute(VALUE)));
    }

    protected static void setListAttribute(Element element, Map<String, Object> properties) throws CoreException {
        String listKey = element.getAttribute(KEY);
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        ArrayList<String> list = new ArrayList<String>(entryCount);
        Node node = null;
        Element selement = null;
        int i = 0;
        while (i < entryCount) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1 && (selement = (Element)node).getNodeName().equalsIgnoreCase(LIST_ENTRY)) {
                String value = selement.getAttribute(VALUE);
                list.add(value);
            }
            ++i;
        }
        properties.put(listKey, list);
    }

    protected static void setSetAttribute(Element element, Map<String, Object> properties) throws CoreException {
        String setKey = element.getAttribute(KEY);
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        HashSet<String> set = new HashSet<String>(entryCount);
        Node node = null;
        Element selement = null;
        int i = 0;
        while (i < entryCount) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1 && (selement = (Element)node).getNodeName().equalsIgnoreCase(SET_ENTRY)) {
                set.add(element.getAttribute(VALUE));
            }
            ++i;
        }
        properties.put(setKey, set);
    }

    protected static void setMapAttribute(Element element, Map<String, Object> properties) throws CoreException {
        String mapKey = element.getAttribute(KEY);
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        HashMap<String, String> map = new HashMap<String, String>(entryCount);
        Node node = null;
        Element selement = null;
        int i = 0;
        while (i < entryCount) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1 && (selement = (Element)node).getNodeName().equalsIgnoreCase(MAP_ENTRY)) {
                map.put(selement.getAttribute(KEY), selement.getAttribute(VALUE));
            }
            ++i;
        }
        properties.put(mapKey, map);
    }

    public static IProject getSnapshotsProject() throws CoreException {
        IProject snapshotsProject = null;
        String defaultProjectName = "Snapshots";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        snapshotsProject = workspace.getRoot().getProject(defaultProjectName);
        if (snapshotsProject.exists()) {
            if (!snapshotsProject.isOpen()) {
                snapshotsProject.open((IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            IProjectDescription description = workspace.newProjectDescription(defaultProjectName);
            description.setLocation(null);
            try {
                snapshotsProject.create(description, (IProgressMonitor)new NullProgressMonitor());
                snapshotsProject.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
        }
        return snapshotsProject;
    }

    public static boolean launchAlbumSession(Album album) {
        IPath albumPath = album.getLocation();
        try {
            if (!album.isLoaded()) {
                album.loadAlbum(false);
            }
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, e);
            return false;
        }
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = lm.getLaunchConfigurationType(album.getLaunchTypeID());
        if (launchType == null) {
            return false;
        }
        ILaunchConfiguration proxyLaunchConfig = SnapshotUtils.findExistingLaunchForAlbum(album);
        if (proxyLaunchConfig == null) {
            String lcName = lm.generateLaunchConfigurationName(album.getDisplayName());
            ILaunchConfigurationWorkingCopy proxyLaunchConfigWC = null;
            try {
                proxyLaunchConfigWC = launchType.newInstance(null, lcName);
                proxyLaunchConfigWC.setAttributes(album.getLaunchProperties());
                proxyLaunchConfigWC.setAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", albumPath.toOSString());
                proxyLaunchConfig = proxyLaunchConfigWC.doSave();
            }
            catch (CoreException e) {
                EDCDebugger.getMessageLogger().logError(null, e);
            }
        }
        if (proxyLaunchConfig != null) {
            final ILaunchConfiguration finalProxyLC = proxyLaunchConfig;
            Job launchJob = new Job("Launching " + albumPath.toFile().getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        finalProxyLC.launch("debug", (IProgressMonitor)new NullProgressMonitor(), false, true);
                    }
                    catch (CoreException e) {
                        EDCDebugger.getMessageLogger().logError(null, e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            launchJob.schedule();
        }
        return false;
    }

    public static boolean isSnapshotLaunchConfig(ILaunchConfiguration launchConfiguration) {
        try {
            String albumFile = launchConfiguration.getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", "");
            return albumFile.length() > 0;
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
            return false;
        }
    }

    public static ILaunchConfiguration findExistingLaunchForAlbum(IAlbum album) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = lm.getLaunchConfigurationType(album.getLaunchTypeID());
        if (launchType == null) {
            return null;
        }
        try {
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = lm.getLaunchConfigurations(launchType);
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (album.getLocation().toOSString().equals(configuration.getAttribute("org.eclipse.cdt.debug.edc.internal.launch.snapshotAlbum", ""))) {
                    return configuration;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        return null;
    }

    public static void playSoundFile(File soundFile) {
        if (soundFile.exists()) {
            class SoundPlayer
            extends Thread {
                private final /* synthetic */ File val$soundFile;

                SoundPlayer(File file) {
                    this.val$soundFile = file;
                }

                @Override
                public void run() {
                    try {
                        AudioInputStream soundStream = AudioSystem.getAudioInputStream(this.val$soundFile);
                        AudioFormat audioFormat = soundStream.getFormat();
                        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
                        SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                        byte[] soundBuffer = new byte[5000];
                        sourceDataLine.open(audioFormat);
                        sourceDataLine.start();
                        int dataCount = 0;
                        while ((dataCount = soundStream.read(soundBuffer, 0, soundBuffer.length)) != -1) {
                            if (dataCount <= 0) continue;
                            sourceDataLine.write(soundBuffer, 0, dataCount);
                        }
                        sourceDataLine.drain();
                        sourceDataLine.close();
                    }
                    catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (LineUnavailableException lineUnavailableException) {}
                }
            }
            new SoundPlayer(soundFile).start();
        }
    }

    private static String serializeObjectToString(Object value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(value);
        return new String(new Hex().encode(baos.toByteArray()));
    }

    private static Object createSerializedObjectFromString(String objectValue) throws DecoderException, IOException, ClassNotFoundException {
        final ClassLoader classLoader = ((Object)((Object)EDCDebugger.getDefault())).getClass().getClassLoader();
        ByteArrayInputStream bais = new ByteArrayInputStream(Hex.decodeHex((char[])objectValue.toCharArray()));
        ObjectInputStream ois = new ObjectInputStream(bais){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String name = desc.getName();
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return super.resolveClass(desc);
                }
            }
        };
        return ois.readObject();
    }
}

