/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.io.IOException;
import java.math.BigInteger;
import java.text.MessageFormat;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.symbols.InvalidVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.MemoryVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfInfoReader;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfMessages;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IRegisterVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.core.runtime.CoreException;

public class LocationExpression
implements ILocationProvider {
    protected final IStreamBuffer location;
    protected final int addressSize;
    protected final IScope scope;

    public LocationExpression(IStreamBuffer location, int addressSize, IScope scope) {
        this.location = location;
        this.addressSize = addressSize;
        this.scope = scope;
    }

    public boolean getRegisterOffset(Object[] offset) {
        if (this.location != null) {
            this.location.position(0L);
            byte opcodeB = this.location.get();
            int opcode = 0xFF & opcodeB;
            if (80 <= opcode && opcode <= 146) {
                try {
                    offset[0] = DwarfInfoReader.read_signed_leb128(this.location);
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public boolean getGlobalVariableAddress(Object[] offset) {
        if (this.location != null) {
            this.location.position(0L);
            byte opcodeB = this.location.get();
            int opcode = 0xFF & opcodeB;
            if (opcode == 3) {
                try {
                    offset[0] = DwarfInfoReader.readAddress(this.location, this.addressSize);
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public int getRegisterID() {
        if (this.location != null) {
            this.location.position(0L);
            byte opcodeB = this.location.get();
            int opcode = 0xFF & opcodeB;
            if (opcode >= 80 && opcode <= 111) {
                return opcode - 80;
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized IVariableLocation getLocation(EDCServicesTracker tracker, IStack.IFrameDMContext context, IAddress forLinkAddress, boolean isNonLocalConstVariable) {
        if (this.location == null) {
            return null;
        }
        opStack = new IVariableLocation[8];
        opStackPtr = 0;
        this.location.position(0L);
        try lbl-1000:
        // 12 sources

        {
            block18: while (this.location.hasRemaining()) {
                opcodeB = this.location.get();
                opcode = 255 & opcodeB;
                if (opcode >= 48 && opcode <= 79) {
                    opStack[opStackPtr++] = new MemoryVariableLocation(tracker, (IDMContext)context, BigInteger.valueOf(opcode - 48), true);
                    continue;
                }
                if (opcode >= 80 && opcode <= 111) {
                    opStack[opStackPtr++] = new RegisterVariableLocation(tracker, (IDMContext)context, null, opcode - 80);
                    continue;
                }
                if (opcode >= 112 && opcode <= 143) {
                    loc = new RegisterVariableLocation(tracker, (IDMContext)context, null, opcode - 112);
                    try {
                        value = loc.readValue(this.addressSize);
                        offset = DwarfInfoReader.read_signed_leb128(this.location);
                        opStack[opStackPtr++] = new MemoryVariableLocation(tracker, (IDMContext)context, value.add(BigInteger.valueOf(offset)), true);
                        continue;
                    }
                    catch (CoreException e) {
                        return new InvalidVariableLocation(e.getMessage());
                    }
                }
                switch (opcode) {
                    case 150: {
                        ** break;
                    }
                    case 3: {
                        addrValue = DwarfInfoReader.readAddress(this.location, this.addressSize);
                        opStack[opStackPtr++] = new MemoryVariableLocation(tracker, (IDMContext)context, BigInteger.valueOf(addrValue), true, isNonLocalConstVariable);
                        ** break;
                    }
                    case 6: {
                        this.ensureStack(opStackPtr, 1);
                        try {
                            addr = opStack[opStackPtr - 1].readValue(this.addressSize);
                            loc = new MemoryVariableLocation(tracker, (IDMContext)context, addr, true, isNonLocalConstVariable);
                            opStack[opStackPtr - 1] = loc;
                            ** break;
                        }
                        catch (CoreException e) {
                            return new InvalidVariableLocation(e.getMessage());
                        }
                    }
                    case 35: {
                        this.ensureStack(opStackPtr, 1);
                        offset = DwarfInfoReader.read_unsigned_leb128(this.location);
                        opStack[opStackPtr - 1] = opStack[opStackPtr - 1].addOffset(offset);
                        ** break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        return new InvalidVariableLocation(MessageFormat.format(DwarfMessages.NotImplementedFormat, new Object[]{String.valueOf(DwarfMessages.LocationExpression_DW_OP) + opcode}));
                    }
                    case 144: {
                        regNum = DwarfInfoReader.read_unsigned_leb128(this.location);
                        opStack[opStackPtr++] = new RegisterVariableLocation(tracker, (IDMContext)context, null, (int)regNum);
                        ** break;
                    }
                    case 145: {
                        offset = DwarfInfoReader.read_signed_leb128(this.location);
                        functionScope = null;
                        functionScope = this.getFunctionScope(forLinkAddress);
                        framePtrLoc = functionScope.getFrameBaseLocation().getLocation(tracker, context, forLinkAddress, false);
                        if (framePtrLoc == null) continue block18;
                        if (framePtrLoc instanceof InvalidVariableLocation) {
                            return framePtrLoc;
                        }
                        if (framePtrLoc instanceof IRegisterVariableLocation) {
                            frame = framePtrLoc.readValue(this.addressSize);
                            opStack[opStackPtr++] = new MemoryVariableLocation(tracker, (IDMContext)context, frame.add(BigInteger.valueOf(offset)), true);
                            ** break;
                        }
                        opStack[opStackPtr++] = framePtrLoc.addOffset(offset);
                        ** break;
                    }
                    case 147: {
                        if (!LocationExpression.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        return new InvalidVariableLocation(MessageFormat.format(DwarfMessages.NotImplementedFormat, new Object[]{DwarfMessages.LocationExpression_MultiRegisterVariable}));
                    }
                    case 146: 
                    case 148: 
                    case 149: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: {
                        if (!LocationExpression.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        return new InvalidVariableLocation(MessageFormat.format(DwarfMessages.NotImplementedFormat, new Object[]{String.valueOf(DwarfMessages.LocationExpression_DW_OP) + opcode}));
                    }
                }
                if (!LocationExpression.$assertionsDisabled) {
                    throw new AssertionError();
                }
                return new InvalidVariableLocation(MessageFormat.format(DwarfMessages.InternalErrorFormat, new Object[]{String.valueOf(DwarfMessages.LocationExpression_UnexpectedOperand) + opcode}));
            }
        }
        catch (CoreException e) {
            return new InvalidVariableLocation(e.getMessage());
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, e);
        }
        if (opStackPtr == 1) {
            return opStack[0];
        }
        if (!LocationExpression.$assertionsDisabled) {
            throw new AssertionError();
        }
        return new InvalidVariableLocation(MessageFormat.format(DwarfMessages.InternalErrorFormat, new Object[]{DwarfMessages.LocationExpression_BadStackSize}));
    }

    private void ensureStack(int opStackPtr, int needed) throws CoreException {
        if (opStackPtr < needed) {
            throw EDCDebugger.newCoreException(MessageFormat.format(DwarfMessages.InternalErrorFormat, MessageFormat.format("expected {0} stack operands but had {1}", needed, opStackPtr)));
        }
    }

    private IFunctionScope getFunctionScope(IAddress forLinkAddress) throws CoreException {
        IFunctionScope functionScope = null;
        if (this.scope instanceof IFunctionScope) {
            functionScope = (IFunctionScope)this.scope;
        } else {
            IScope parent = this.scope.getParent();
            while (parent != null && !(parent instanceof IFunctionScope)) {
                parent = parent.getParent();
            }
            if (parent == null) {
                throw EDCDebugger.newCoreException("No function scope for " + this.scope + " at " + forLinkAddress.toHexAddressString());
            }
            functionScope = (IFunctionScope)parent;
        }
        while (functionScope.getParent() instanceof IFunctionScope) {
            functionScope = (IFunctionScope)functionScope.getParent();
        }
        return functionScope;
    }

    @Override
    public boolean isLocationKnown(IAddress forLinkAddress) {
        return true;
    }

    public IScope getScope() {
        return this.scope;
    }

    @Override
    public boolean lifetimeMustMatchScope() {
        return true;
    }
}

