/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.symbols.ISection;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ISectionMapper;
import org.eclipse.cdt.debug.edc.internal.symbols.files.UnmanglingException;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSection;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.ISymbol;
import org.eclipse.cdt.debug.edc.symbols.IUnmangler;
import org.eclipse.core.runtime.IPath;

public abstract class BaseExecutableSymbolicsReader
implements IExecutableSymbolicsReader {
    protected final IPath binaryFile;
    protected Map<String, IExecutableSection> executableSections = new HashMap<String, IExecutableSection>();
    protected List<ISection> sections = new ArrayList<ISection>();
    protected List<ISymbol> symbols = new ArrayList<ISymbol>();
    protected IAddress exeBaseAddress;
    protected long modificationDate;
    protected ISectionMapper sectionMapper;
    protected IUnmangler unmangler;

    public BaseExecutableSymbolicsReader(IPath binaryFile) {
        this.binaryFile = binaryFile;
    }

    @Override
    public void dispose() {
        if (this.sectionMapper != null) {
            this.sectionMapper.dispose();
            this.sectionMapper = null;
        }
        this.sections.clear();
        this.symbols.clear();
    }

    @Override
    public IPath getSymbolFile() {
        return this.binaryFile;
    }

    @Override
    public Collection<IExecutableSection> getExecutableSections() {
        return Collections.unmodifiableCollection(this.executableSections.values());
    }

    @Override
    public IExecutableSection findExecutableSection(String sectionName) {
        return this.executableSections.get(sectionName);
    }

    @Override
    public Collection<ISection> getSections() {
        return Collections.unmodifiableCollection(this.sections);
    }

    @Override
    public Collection<ISymbol> getSymbols() {
        return Collections.unmodifiableCollection(this.symbols);
    }

    @Override
    public ISymbol getSymbolAtAddress(IAddress linkAddress) {
        int insertion = Collections.binarySearch(this.symbols, linkAddress);
        if (insertion >= 0) {
            return this.symbols.get(insertion);
        }
        if (insertion == -1) {
            return null;
        }
        ISymbol symbol = this.symbols.get((insertion = -insertion - 1) - 1);
        if (linkAddress.compareTo((Object)symbol.getAddress().add(symbol.getSize())) < 0) {
            return symbol;
        }
        return null;
    }

    @Override
    public IAddress getBaseLinkAddress() {
        return this.exeBaseAddress;
    }

    @Override
    public long getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public Collection<ISymbol> findSymbols(String name) {
        String symName;
        ArrayList<ISymbol> matchSymbols = new ArrayList<ISymbol>();
        for (ISymbol symbol : this.symbols) {
            symName = symbol.getName();
            if (!symName.equals(name)) continue;
            matchSymbols.add(symbol);
        }
        if (!matchSymbols.isEmpty()) {
            return matchSymbols;
        }
        if (this.unmangler != null) {
            for (ISymbol symbol : this.symbols) {
                symName = this.unmangler.undecorate(symbol.getName());
                if (!symName.equals(name)) continue;
                matchSymbols.add(symbol);
            }
        }
        return matchSymbols;
    }

    @Override
    public Collection<ISymbol> findUnmangledSymbols(String name) {
        ArrayList<ISymbol> matchSymbols = new ArrayList<ISymbol>();
        if (this.unmangler != null) {
            String nameNoSpaces = (name = this.unmangler.undecorate(name)).replaceAll("\\s", "");
            if (nameNoSpaces.startsWith("::")) {
                nameNoSpaces = nameNoSpaces.substring(2);
            }
            boolean nameNoArguments = !nameNoSpaces.endsWith(")");
            String undecoratedBase = nameNoSpaces;
            int idx = undecoratedBase.lastIndexOf(58);
            if (idx >= 0) {
                undecoratedBase = undecoratedBase.substring(idx + 1);
            }
            if ((idx = undecoratedBase.indexOf(40)) >= 0) {
                undecoratedBase = undecoratedBase.substring(0, idx);
            }
            for (ISymbol symbol : this.symbols) {
                String symName = symbol.getName();
                if (!symName.contains(undecoratedBase)) continue;
                try {
                    String unmangledNoArguments;
                    String unmangled = this.unmangler.unmangle(this.unmangler.undecorate(symName));
                    if (unmangled == null) continue;
                    String unmangledNoSpaces = unmangled.replaceAll("\\bconst\\s*(?=\\()", "");
                    if ((unmangledNoSpaces = unmangledNoSpaces.replaceAll("\\s", "")).startsWith("::")) {
                        unmangledNoSpaces = unmangledNoSpaces.substring(2);
                    }
                    if (nameNoSpaces.equals(unmangledNoSpaces)) {
                        matchSymbols.add(symbol);
                        continue;
                    }
                    if (!nameNoArguments || (idx = unmangledNoSpaces.lastIndexOf(40)) < 0 || !(unmangledNoArguments = unmangledNoSpaces.substring(0, idx)).equals(nameNoSpaces)) continue;
                    matchSymbols.add(symbol);
                }
                catch (UnmanglingException unmanglingException) {}
            }
            if (!matchSymbols.isEmpty()) {
                return matchSymbols;
            }
        }
        return matchSymbols;
    }

    public IUnmangler getUnmangler() {
        return this.unmangler;
    }
}

