/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACustomButtonRenderer
implements IDACustomButtonRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        if (attr.getDrawType() == 0) {
            this.drawImageButton(gc, rect, state, attr);
        } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
            this.drawButton(gc, rect, state, attr);
        }
        this.drawButtonImage(gc, rect, attr, state);
        this.drawIcon(gc, rect, attr);
    }

    public int computeFontSize(Rectangle rect) {
        if (rect.height > 20) {
            return 10;
        }
        return 8;
    }

    protected void drawImageButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        Image image = attr.getImage(state);
        if (image == null) {
            return;
        }
        gc.drawImage(image, rect.x, rect.y);
        this.drawButtonText(gc, rect, attr, state);
    }

    protected void drawIcon(GC gc, Rectangle parentRect, DACustomButtonAttribute attr) {
        Image icon = attr.getIcon();
        if (icon == null) {
            return;
        }
        gc.drawImage(icon, parentRect.x + 2, parentRect.height / 2 - icon.getBounds().height / 2);
    }

    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        if (attr.getDrawType() == 1) {
            gc.setBackground(attr.getColor(state));
            gc.fillRectangle(rect);
        } else {
            int index = state * 2;
            gc.setForeground(attr.getColor(index));
            gc.setBackground(attr.getColor(index + 1));
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.drawButtonText(gc, r, attr, state);
        Color c = gc.getForeground();
        if (attr.getOutlineColor(state) != null) {
            gc.setForeground(attr.getOutlineColor(state));
        } else {
            gc.setForeground(ColorResources.BLACK);
        }
        gc.drawRectangle(r);
        Rectangle ir = new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        if (attr.getOutlineInColor(state) == null) {
            gc.setForeground(c);
            return;
        }
        gc.setForeground(attr.getOutlineInColor(state));
        gc.drawRectangle(ir);
        gc.setForeground(c);
    }

    protected void drawButtonImage(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        Image img;
        if (attr != null && (img = attr.getButtonImage(state)) != null) {
            Point p = null;
            Rectangle imgRect = img.getBounds();
            int x = 0;
            int y = 0;
            p = attr.getButtonImagePoint();
            if (p == null) {
                int width = rect.width - imgRect.width;
                int height = rect.height - imgRect.height;
                if (width > 0) {
                    x = width / 2;
                }
                if (height > 0) {
                    y = height / 2;
                }
            } else {
                x = p.x;
                y = p.y;
            }
            gc.drawImage(img, x, y);
        }
    }

    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        String text = null;
        Font font = null;
        Point p = null;
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getIcon() != null) {
            Rectangle iconRect = attr.getIcon().getBounds();
            textRect.x += iconRect.width;
            textRect.width -= iconRect.width;
        }
        if ((text = attr.getText()) != null) {
            font = attr.getFont();
            if (font == null) {
                font = new Font((Device)Display.getCurrent(), "Arial", this.computeFontSize(textRect), 0);
                attr.setFont(font);
            }
            gc.setFont(font);
            int x = 0;
            int y = 0;
            int offset = 0;
            p = attr.getFontPoint();
            if (p == null) {
                p = gc.textExtent(text, 8);
                if (attr.getAlign() == 0x1000000) {
                    x = (textRect.width - p.x) / 2 + textRect.x;
                    x = x < 0 ? 0 : x;
                    offset = -2;
                } else {
                    x = textRect.x;
                    offset = 2;
                }
                y = (textRect.height - p.y) / 2;
            } else {
                x = p.x;
                y = p.y;
            }
            if (attr.getFontColor(state) != null) {
                gc.setForeground(attr.getFontColor(state));
            } else {
                gc.setForeground(ColorResources.BLACK);
            }
            if (state == 1) {
                ++x;
                ++y;
            }
            gc.drawString(text, x + offset, y, true);
        }
    }
}

