/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chartBoard;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleAttribute;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleDefaultRenderer;

public class DAChartBoardScaleRenderer
extends DAScaleDefaultRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, DAScaleAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        gc.setBackground(ColorResources.SCALE_BG_COLOR);
        gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getLeftImage() != null && attr.getRightImage() != null && attr.getLeftRect() != null && attr.getRightRect() != null) {
            gc.drawImage(attr.getLeftImage(), attr.getLeftRect().x, attr.getLeftRect().y);
            gc.drawImage(attr.getRightImage(), attr.getRightRect().x, attr.getRightRect().y);
        }
        gc.setBackground(ColorResources.SCALE_AREA_COLOR);
        if (attr.getAreaRect() != null) {
            gc.fillRectangle(attr.getAreaRect());
        }
        if (attr.getThumbRect() != null) {
            if (attr.getThumbImage() != null) {
                gc.drawImage(attr.getThumbImage(), attr.getThumbRect().x, attr.getThumbRect().y);
            } else {
                gc.setBackground(ColorResources.RED);
                gc.fillOval(attr.getThumbRect().x, attr.getThumbRect().y, attr.getThumbRect().width, attr.getThumbRect().height);
            }
        }
    }
}

