/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialogEnum;

public class WarningDialog {
    private Shell parent = null;
    private Shell shell = null;
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;
    private String message = "";
    private boolean returnType = false;
    private String titleText = WidgetLabels.DA_WARNING;
    private Image iconImage = ImageResources.DIALOG_WARNING_ICON;
    public static final int DIALOG_TYPE_SMALL = 0;
    public static final int DIALOG_TYPE_MIDDLE = 1;
    public static final int DIALOG_TYPE_LARGE = 2;
    private int dialogType = 0;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        @Override
        public void handleClickEvent(DACustomButton button) {
            WarningDialog.this.returnType = true;
            WarningDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        @Override
        public void handleClickEvent(DACustomButton button) {
            WarningDialog.this.returnType = false;
            WarningDialog.this.shell.dispose();
        }
    };

    public WarningDialog(Shell parent, int style) {
        this.parent = parent;
    }

    public void setDialogType(int type) {
        this.dialogType = type;
    }

    public boolean open() {
        ArrayList<Integer> sizeInfo = new ArrayList<Integer>();
        DADialogEnum.warningDialogInfo[] warningDialogInfoArray = DADialogEnum.warningDialogInfo.values();
        int n = warningDialogInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DADialogEnum.warningDialogInfo info = warningDialogInfoArray[n2];
            switch (this.dialogType) {
                case 0: {
                    sizeInfo.add(info.getSmall());
                    break;
                }
                case 1: {
                    sizeInfo.add(info.getMiddle());
                    break;
                }
                case 2: {
                    sizeInfo.add(info.getLarge());
                    break;
                }
                default: {
                    Logger.warning((Object)("Invalid dialogType:" + this.dialogType));
                }
            }
            ++n2;
        }
        this.shell = new Shell(this.parent, 67680);
        this.shell.setSize(((Integer)sizeInfo.get(0)).intValue(), ((Integer)sizeInfo.get(1)).intValue());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(this.titleText);
        Composite base = new Composite((Composite)this.shell, 0);
        base.setLayout((Layout)new FormLayout());
        FormData baseData = new FormData();
        baseData.top = new FormAttachment(0, 0);
        baseData.left = new FormAttachment(0, 0);
        baseData.right = new FormAttachment(100, 0);
        baseData.height = (Integer)sizeInfo.get(2);
        base.setLayoutData((Object)baseData);
        base.setVisible(true);
        base.setBackground(ColorResources.DIALOG_BG_UPPER);
        Label icon = new Label(base, 0x40000000);
        icon.setBackground(ColorResources.DIALOG_BG_UPPER);
        icon.setImage(this.iconImage);
        FormData labelData = new FormData();
        labelData.left = new FormAttachment(0, ((Integer)sizeInfo.get(3)).intValue());
        labelData.top = new FormAttachment(0, ((Integer)sizeInfo.get(4)).intValue());
        labelData.height = 64;
        labelData.width = 64;
        icon.setLayoutData((Object)labelData);
        Label strMessage = new Label(base, 0x40004040);
        strMessage.setText(this.message);
        strMessage.setBackground(ColorResources.DIALOG_BG_UPPER);
        strMessage.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        strMessage.setFont(FontResources.ABOUT_TEXT);
        labelData = new FormData();
        labelData.left = new FormAttachment(0, 95);
        labelData.right = new FormAttachment(95, 0);
        labelData.top = new FormAttachment(0, 15);
        labelData.bottom = new FormAttachment(85, 0);
        labelData.height = (Integer)sizeInfo.get(5);
        strMessage.setLayoutData((Object)labelData);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        FormLayout compLayout = new FormLayout();
        buttonComp.setLayout((Layout)compLayout);
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)base, 0);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        this.cancelButton = new DAButton(buttonComp, 0);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 12);
        data.right = new FormAttachment(100, -9);
        data.width = 86;
        data.height = 24;
        this.cancelButton.setLayoutData(data);
        this.okButton = new DAButton(buttonComp, 0);
        this.okButton.addClickListener(this.okButtonListener);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.setButtonFont(FontResources.DIALOG_BUTTON_FONT);
        FormData okData = new FormData();
        okData.top = new FormAttachment(0, 12);
        okData.right = new FormAttachment((Control)this.cancelButton, -5);
        okData.width = 86;
        okData.height = 24;
        this.okButton.setLayoutData(okData);
        this.shell.open();
        Display display = Display.getCurrent();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.shell.dispose();
        return this.returnType;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setIcon(Image img) {
        this.iconImage = img;
    }

    public void setTitleText(String title) {
        this.titleText = title;
    }
}

