/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import org.tizen.dynamicanalyzer.cli.commands.ExitCode;

public abstract class Command {
    protected String name;
    protected int requiredArgsNum;
    protected String helpMessage;
    protected String optsFormat;
    protected static final String helpFormat = "  %-25s : %s%n";

    public Command(String name, int argsNum, String helpMessage, String optsFormat) {
        this.name = name;
        this.requiredArgsNum = argsNum;
        this.helpMessage = helpMessage;
        this.optsFormat = optsFormat;
    }

    public Command(String name, int argsNum, String helpMessage) {
        this.name = name;
        this.requiredArgsNum = argsNum;
        this.helpMessage = helpMessage;
        this.optsFormat = "";
    }

    public boolean checkArgs(String[] args) {
        if (args.length != this.requiredArgsNum) {
            System.err.printf("Incorrect input: '%s' command should have %d arguments.%n", this.name, this.requiredArgsNum);
            return false;
        }
        return true;
    }

    public abstract ExitCode processCommand(String[] var1);

    public void printHelp() {
        String message = String.format(helpFormat, this.name + " " + this.optsFormat, this.helpMessage);
        System.out.println(message);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRequiredArgsNum() {
        return this.requiredArgsNum;
    }

    public void setRequiredArgsNum(int requiredArgsNum) {
        this.requiredArgsNum = requiredArgsNum;
    }
}

