/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.internal.formatter.CCodeFormatter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolFactory {
    public static CodeFormatter createCodeFormatter(Map<String, ?> options) {
        if (options == null) {
            options = CCorePlugin.getOptions();
        }
        String formatterID = (String)options.get("org.eclipse.cdt.core.code_formatter");
        String extID = "CodeFormatter";
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", extID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String initializerID = configElements[j].getAttribute("id");
                    if (initializerID != null && initializerID.equals(formatterID)) {
                        try {
                            Object execExt = configElements[j].createExecutableExtension("class");
                            if (execExt instanceof CodeFormatter) {
                                CodeFormatter formatter = (CodeFormatter)execExt;
                                formatter.setOptions(options);
                                return formatter;
                            }
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e.getStatus());
                            break;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return ToolFactory.createDefaultCodeFormatter(options);
    }

    public static CodeFormatter createDefaultCodeFormatter(Map<String, ?> options) {
        if (options == null) {
            options = CCorePlugin.getOptions();
        }
        return new CCodeFormatter(options);
    }
}

