/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.SettingsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntryStorage {
    private int fKind;
    private static final String EMPTY_STRING = new String();

    public AbstractEntryStorage(int kind) {
        this.fKind = kind;
    }

    public int getKind() {
        return this.fKind;
    }

    public List<ICLanguageSettingEntry> getEntries(List<ICLanguageSettingEntry> list) {
        SettingsSet settings = this.initCache();
        if (list == null) {
            list = new ArrayList<ICLanguageSettingEntry>();
        }
        ICLanguageSettingEntry[] entries = settings.getEntries();
        list.addAll(Arrays.asList(entries));
        return list;
    }

    protected void resetDefaults() {
        SettingsSet settings = this.createEmptySettings();
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        int i = 0;
        while (i < levels.length) {
            this.obtainEntriesFromLevel(i, null);
            ++i;
        }
    }

    public void setEntries(ICLanguageSettingEntry[] entries) {
        if (entries == null) {
            this.resetDefaults();
            return;
        }
        SettingsSet settings = this.initCache();
        settings.applyEntries(entries);
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        int i = 0;
        while (i < levels.length) {
            this.obtainEntriesFromLevel(i, levels[i]);
            ++i;
        }
    }

    protected SettingsSet initCache() {
        SettingsSet settings = this.createEmptySettings();
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        int i = 0;
        while (i < levels.length) {
            this.putEntriesToLevel(i, levels[i]);
            ++i;
        }
        settings.adjustOverrideState();
        return settings;
    }

    protected abstract void putEntriesToLevel(int var1, SettingsSet.SettingLevel var2);

    protected abstract void obtainEntriesFromLevel(int var1, SettingsSet.SettingLevel var2);

    protected abstract SettingsSet createEmptySettings();

    public static String[] macroNameValueFromValue(String value) {
        String[] nv = new String[2];
        int index = value.indexOf(61);
        if (index > 0) {
            nv[0] = value.substring(0, index);
            nv[1] = value.substring(index + 1);
        } else {
            nv[0] = value;
            nv[1] = EMPTY_STRING;
        }
        return nv;
    }
}

