/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process.processes;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.CreateFolder;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CreateSourceFolder
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        this.createSourceFolder(args[0].getSimpleValue(), args[1].getSimpleValue(), monitor);
    }

    protected void createSourceFolder(String projectName, String targetPath, IProgressMonitor monitor) throws ProcessFailureException {
        if (targetPath == null || targetPath.length() == 0) {
            return;
        }
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectHandle.exists()) {
            throw new ProcessFailureException(String.valueOf(Messages.getString("CreateSourceFolder.0")) + projectName);
        }
        CreateFolder.createFolder(projectName, targetPath, monitor);
        IPath projPath = projectHandle.getFullPath();
        IFolder folder = projectHandle.getFolder(targetPath);
        try {
            ICProject cProject = CoreModel.getDefault().create(projectHandle);
            if (cProject != null) {
                if (CCorePlugin.getDefault().isNewStyleProject(cProject.getProject())) {
                    this.createNewStyleProjectFolder(monitor, projectHandle, folder);
                } else {
                    this.createFolder(targetPath, monitor, projPath, cProject);
                }
            }
        }
        catch (WriteAccessException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString("CreateSourceFolder.2")) + e.getMessage(), e);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString("CreateSourceFolder.2")) + e.getMessage(), e);
        }
    }

    private void createNewStyleProjectFolder(IProgressMonitor monitor, IProject projectHandle, IFolder folder) throws CoreException, WriteAccessException {
        CSourceEntry newEntry = new CSourceEntry(folder, null, 0);
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(projectHandle);
        ICConfigurationDescription[] configs = description.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            ICConfigurationDescription config = configs[i];
            ICSourceEntry[] entries = config.getSourceEntries();
            HashSet<ICSourceEntry> set = new HashSet<ICSourceEntry>();
            int j = 0;
            while (j < entries.length) {
                if (new Path(entries[j].getValue()).segmentCount() != 1) {
                    set.add(entries[j]);
                }
                ++j;
            }
            set.add(newEntry);
            config.setSourceEntries(set.toArray(new ICSourceEntry[set.size()]));
            ++i;
        }
        CCorePlugin.getDefault().setProjectDescription(projectHandle, description, false, monitor);
    }

    private void createFolder(String targetPath, IProgressMonitor monitor, IPath projPath, ICProject cProject) throws CModelException {
        IPathEntry[] entries = cProject.getRawPathEntries();
        ArrayList<IPathEntry> newEntries = new ArrayList<IPathEntry>(entries.length + 1);
        int projectEntryIndex = -1;
        IPath path = projPath.append(targetPath);
        int i = 0;
        while (i < entries.length) {
            IPathEntry curr = entries[i];
            if (path.equals((Object)curr.getPath())) {
                return;
            }
            if (projPath.equals((Object)curr.getPath())) {
                projectEntryIndex = i;
            }
            newEntries.add(curr);
            ++i;
        }
        ISourceEntry newEntry = CoreModel.newSourceEntry(path);
        if (projectEntryIndex != -1) {
            newEntries.set(projectEntryIndex, newEntry);
        } else {
            newEntries.add(CoreModel.newSourceEntry(path));
        }
        cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
    }
}

