/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.combo;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public class DACustomComboRenderer
implements IDACustomButtonRenderer {
    @Override
    public void draw(GC gc, Canvas combo, int state, DACustomButtonAttribute attr) {
        Rectangle rect = combo.getClientArea();
        if (attr.getDrawType() == 0) {
            this.drawImageButton(gc, rect, state, attr);
        } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
            this.drawButton(gc, rect, state, attr);
        } else {
            Logger.debug((Object)("DACustomCombo drawType : " + state));
        }
    }

    protected void drawImageButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        Image image = attr.getImage(state);
        if (image == null) {
            return;
        }
        gc.drawImage(image, rect.x, rect.y);
        this.drawButtonText(gc, rect, attr, state);
        Rectangle clipping = new Rectangle(rect.x + rect.width - 17, rect.y, 17, rect.height);
        gc.setClipping(clipping);
        gc.drawImage(image, rect.x, rect.y);
    }

    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        if (attr.getDrawType() == 1) {
            gc.setBackground(attr.getColor(state));
            gc.fillRectangle(rect);
        } else if (attr.getDrawType() == 2) {
            int index = state * 2;
            gc.setForeground(attr.getColor(index));
            gc.setBackground(attr.getColor(index + 1));
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        }
        this.drawButtonText(gc, rect, attr, state);
        Color c = gc.getForeground();
        Rectangle r = new Rectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        if (attr.getOutlineColor(state) == null) {
            gc.setForeground(c);
            return;
        }
        gc.setForeground(attr.getOutlineColor(state));
        gc.drawRectangle(r);
        gc.setForeground(c);
        this.drawButtonImage(gc, rect, attr, state);
    }

    protected void drawButtonImage(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        Image img;
        if (attr != null && (img = attr.getButtonImage(state)) != null) {
            Point p = null;
            Rectangle imgRect = img.getBounds();
            int x = 0;
            int y = 0;
            p = attr.getButtonImagePoint();
            if (p == null) {
                int width = rect.width - imgRect.width;
                int height = rect.height - imgRect.height;
                if (width > 0) {
                    x = width / 2;
                }
                if (height > 0) {
                    y = height / 2;
                }
            } else {
                x = p.x;
                y = p.y;
            }
            gc.drawImage(img, x, y);
        }
    }

    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        Font font = attr.getFont();
        Point fontPoint = attr.getFontPoint();
        String text = attr.getText();
        int align = attr.getAlign();
        if (font == null) {
            gc.setFont(FontResources.COMBO);
        } else {
            gc.setFont(font);
        }
        if (attr.getFontColor(state) != null) {
            gc.setForeground(attr.getFontColor(state));
        } else if (state == 3) {
            gc.setForeground(ColorResources.COMBO_DISABLE_FONT);
        } else {
            gc.setForeground(ColorResources.COMBO_ENABLE_FONT);
        }
        if (text == null) {
            text = "";
        }
        if (fontPoint == null) {
            Point p = gc.textExtent(text, 8);
            int textX = 0;
            textX = align == 16384 ? 5 : (align == 131072 ? rect.width - p.x : rect.width / 2 - p.x / 2);
            gc.drawString(text, textX, (rect.height - p.y) / 2, true);
        } else {
            gc.drawString(text, fontPoint.x, fontPoint.y, true);
        }
    }
}

