/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.timer.IAlarm;

public class TimerClock
extends Canvas {
    private static final int MIN_TIME_X = 33;
    private static final int COLON_X2 = 58;
    private static final int SEC_TIME_X = 70;
    private static final int TIME_WIDTH = 11;
    private static final int HOUR = 3600000;
    private static final int MIN = 60000;
    private static final int SEC = 1000;
    private static final int TWO_DIGIT = 10;
    private static final int THREE_DIGIT = 100;
    private static final int TIMER_PERIOD = 1000;
    private static final String ZERO = "0";
    private Timer timer;
    private long startTime;
    private long time;
    private long alarmTime = -1L;
    private IAlarm alarm = null;
    private Image bgImage = null;
    private Font clockFont = null;
    private Color fontColor = null;
    private Canvas me = null;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Rectangle myRect = TimerClock.this.me.getClientArea();
            if (TimerClock.this.bgImage != null) {
                myRect = TimerClock.this.me.getClientArea();
                gc.drawImage(TimerClock.this.bgImage, myRect.x, myRect.y);
            } else {
                gc.setBackground(ColorResources.BLUE);
                gc.fillRectangle(myRect);
            }
            TimeString timeString = TimerClock.this.getTimeString(TimerClock.this.time);
            if (TimerClock.this.clockFont != null) {
                gc.setFont(TimerClock.this.clockFont);
            }
            if (TimerClock.this.fontColor != null) {
                gc.setForeground(TimerClock.this.fontColor);
            } else {
                gc.setForeground(ColorResources.WHITE);
            }
            Point p = gc.textExtent(timeString.min, 8);
            int y = (myRect.height - p.y) / 2;
            if (Integer.parseInt(timeString.min100) > 0) {
                gc.drawText(timeString.min100, 33, y, true);
                gc.drawText(timeString.min, 41, y, true);
                gc.drawText(timeString.min2, 49, y, true);
                gc.drawText(":", 58, y, true);
                gc.drawText(timeString.sec, 70, y, true);
                gc.drawText(timeString.sec2, 81, y, true);
            } else {
                gc.drawText(timeString.min, 33, y, true);
                gc.drawText(timeString.min2, 44, y, true);
                gc.drawText(":", 58, y, true);
                gc.drawText(timeString.sec, 70, y, true);
                gc.drawText(timeString.sec2, 81, y, true);
            }
        }
    };

    public TimerClock(Composite parent, int style) {
        super(parent, style);
        this.me = this;
        this.addPaintListener(this.paintListener);
        this.setBackground(ColorResources.RED);
    }

    private TimeString getTimeString(long time) {
        long hour = time / 3600000L;
        long min100 = time / 60000L / 100L;
        long min = time / 60000L - min100 * 100L;
        long minTime = min100 * 100L + min;
        long sec = (time - minTime * 60000L) / 1000L;
        if (10L > hour) {
            Long.toString(hour);
        } else {
            Long.toString(hour / 10L);
            Long.toString(hour % 10L);
        }
        String minStr100 = "";
        String minStr = "";
        String minStr2 = "";
        if (10L > minTime) {
            minStr100 = ZERO;
            minStr = ZERO;
            minStr2 = Long.toString(min);
        } else if (100L > minTime) {
            minStr100 = ZERO;
            minStr = Long.toString(min / 10L);
            minStr2 = Long.toString(min % 10L);
        } else {
            minStr100 = Long.toString(min100);
            minStr = Long.toString(min / 10L);
            minStr2 = Long.toString(min % 10L);
        }
        String secStr = "";
        String secStr2 = "";
        if (10L > sec) {
            secStr = ZERO;
            secStr2 = Long.toString(sec);
        } else {
            secStr = Long.toString(sec / 10L);
            secStr2 = Long.toString(sec % 10L);
        }
        TimeString timeString = new TimeString();
        timeString.min100 = minStr100.toString();
        timeString.min = minStr.toString();
        timeString.min2 = minStr2.toString();
        timeString.sec = secStr.toString();
        timeString.sec2 = secStr2.toString();
        return timeString;
    }

    public void start() {
        if (this.timer != null) {
            this.stop();
        }
        this.startTime = System.currentTimeMillis();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimerClock.this.time = System.currentTimeMillis() - TimerClock.this.startTime;
                        if (TimerClock.this.timer != null) {
                            TimerClock.this.redraw();
                        }
                        if (TimerClock.this.alarmTime <= TimerClock.this.time * 1000L && TimerClock.this.alarmTime > 0L) {
                            if (TimerClock.this.alarm != null) {
                                TimerClock.this.alarm.action();
                            }
                            TimerClock.this.removeAlarm();
                        }
                    }
                });
            }
        }, new Date(), 1000L);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            Logger.debug((Object)"timer canceled!! ");
        }
    }

    public void setTime(long millTime) {
        this.time = millTime;
        this.redraw();
    }

    public long getTime() {
        return this.time;
    }

    public long getTimeInMicroseconds() {
        return this.time * 1000L;
    }

    public void setBgImage(Image bg) {
        this.bgImage = bg;
    }

    public void setClockFont(Font font) {
        this.clockFont = font;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Point getTimerSize() {
        Rectangle r = this.me.getClientArea();
        return new Point(r.width, r.height);
    }

    public void clear() {
        this.setTime(0L);
        this.alarm = null;
        this.alarmTime = -1L;
    }

    public void setAlarm(long time, IAlarm alarm) {
        this.alarmTime = time;
        this.alarm = alarm;
    }

    public void removeAlarm() {
        if (this.alarm != null) {
            this.alarm = null;
        }
        this.alarmTime = -1L;
    }

    private static class TimeString {
        public String min100;
        public String min;
        public String min2;
        public String sec;
        public String sec2;

        private TimeString() {
        }
    }
}

