/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.utility;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedImage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static AtomicInteger referenceCount = new AtomicInteger();
    private int callCount = 0;
    private int hitCount = 0;
    private Image image;
    private int hashCode = 0;

    public Image get(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        ++this.callCount;
        int n = imageDescriptor.hashCode();
        if (this.image != null) {
            if (this.hashCode == n) {
                ++this.hitCount;
                return this.image;
            }
            this.dispose();
        }
        this.image = imageDescriptor.createImage();
        if (this.image != null) {
            referenceCount.incrementAndGet();
            this.hashCode = n;
            this.logger.debug(MessageFormat.format("Cached image is created: {0}", this.hashCode));
        } else {
            this.logger.error("Failed to create a image. (Out of image handles)");
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            int n = referenceCount.decrementAndGet();
            this.logger.debug(MessageFormat.format("Cached image is disposed: {0} (Remained {1} / HitRate {2}%)", this.hashCode, n, this.getHitRate()));
        }
        this.image = null;
        this.hashCode = 0;
        this.callCount = 0;
        this.hitCount = 0;
    }

    private double getHitRate() {
        if (this.callCount == 0) {
            return 0.0;
        }
        return (double)(this.hitCount * 100) / (double)this.callCount;
    }
}

