<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="index">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name(parent::node())='view'">
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_index_add(parent);', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->root_container = vc->', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_index_add(vc->', $parent, ');', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />
		<xsl:choose>
			<xsl:when test="@autohide='false'">
				<xsl:value-of select="concat($indentation1 , 'elm_index_autohide_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1 , 'elm_index_autohide_disabled_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@indicator='false'">
				<xsl:value-of select="concat($indentation1 , 'elm_index_indicator_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1 , 'elm_index_indicator_disabled_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:call-template name="style">
			<xsl:with-param name="style" select="@style" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="@horizontal='true'">
				<xsl:value-of select="concat($indentation1 , 'elm_index_horizontal_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1 , 'elm_index_horizontal_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
		</xsl:apply-templates>

		<xsl:call-template name="disable">
			<xsl:with-param name="disable" select="@disable" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:value-of select="concat($indentation1, 'elm_index_level_go(vc->', @id, ', 0);', $newline)" />

		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>

</xsl:stylesheet>
