/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Color
extends Resource {
    public GdkColor handle;
    int alpha = 255;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3, 255);
        this.init();
    }

    public Color(Device device, int n, int n2, int n3, int n4) {
        super(device);
        this.init(n, n2, n3, n4);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, 255);
        this.init();
    }

    public Color(Device device, RGBA rGBA) {
        super(device);
        if (rGBA == null) {
            SWT.error(4);
        }
        this.init(rGBA.rgb.red, rGBA.rgb.green, rGBA.rgb.blue, rGBA.alpha);
        this.init();
    }

    public Color(Device device, RGB rGB, int n) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue, n);
        this.init();
    }

    void destroy() {
        int n = this.handle.pixel;
        if (this.device.colorRefCount != null) {
            int n2 = n;
            this.device.colorRefCount[n2] = this.device.colorRefCount[n2] - 1;
            if (this.device.colorRefCount[n2] == 0) {
                this.device.gdkColors[n] = null;
            }
        }
        if (!OS.GTK3) {
            long l = OS.gdk_colormap_get_system();
            OS.gdk_colormap_free_colors(l, this.handle, 1);
        }
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        GdkColor gdkColor = color.handle;
        if (this.handle == gdkColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == gdkColor.red && this.handle.green == gdkColor.green && this.handle.blue == gdkColor.blue && this.alpha == color.alpha;
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue ^ this.alpha;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public static Color gtk_new(Device device, GdkColor gdkColor) {
        return Color.gtk_new(device, gdkColor, 255);
    }

    public static Color gtk_new(Device device, GdkColor gdkColor, int n) {
        Color color = new Color(device);
        color.handle = gdkColor;
        color.alpha = n;
        return color;
    }

    void init(int n, int n2, int n3, int n4) {
        long l;
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0) {
            SWT.error(5);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(n & 0xFF | (n & 0xFF) << 8);
        gdkColor.green = (short)(n2 & 0xFF | (n2 & 0xFF) << 8);
        gdkColor.blue = (short)(n3 & 0xFF | (n3 & 0xFF) << 8);
        this.alpha = n4;
        if (!OS.GTK3 && !OS.gdk_colormap_alloc_color(l = OS.gdk_colormap_get_system(), gdkColor, true, true)) {
            gdkColor = new GdkColor();
            OS.gdk_colormap_alloc_color(l, gdkColor, true, true);
        }
        this.handle = gdkColor;
        if (this.device.colorRefCount != null) {
            GdkColor gdkColor2 = new GdkColor();
            gdkColor2.red = this.handle.red;
            gdkColor2.green = this.handle.green;
            gdkColor2.blue = this.handle.blue;
            gdkColor2.pixel = this.handle.pixel;
            this.device.gdkColors[gdkColor2.pixel] = gdkColor2;
            int n5 = gdkColor2.pixel;
            this.device.colorRefCount[n5] = this.device.colorRefCount[n5] + 1;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

