/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        int[] nArray;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        int n = table.handle;
        int n2 = OS.gtk_tree_view_get_selection(n);
        int n3 = OS.gtk_tree_selection_get_selected_rows(n2, nArray = null);
        if (n3 == 0) {
            return null;
        }
        int n4 = Math.min(10, OS.g_list_length(n3));
        int n5 = n3;
        Display display = table.getDisplay();
        if (n4 == 1) {
            int n6 = OS.g_list_nth_data(n3, 0);
            int n7 = OS.gtk_tree_view_create_row_drag_icon(n, n6);
            this.dragSourceImage = Image.gtk_new(display, 1, n7, 0);
            OS.gtk_tree_path_free(n6);
        } else {
            int n8;
            int n9;
            int n10 = 0;
            int n11 = 0;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[n4];
            int[] nArray5 = new int[n4];
            int[] nArray6 = new int[n4];
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (n9 = 0; n9 < n4; ++n9) {
                n8 = OS.g_list_data(n3);
                OS.gtk_tree_view_get_cell_area(n, n8, 0, gdkRectangle);
                nArray6[n9] = OS.gtk_tree_view_create_row_drag_icon(n, n8);
                if (OS.GTK3) {
                    nArray2[0] = Cairo.cairo_xlib_surface_get_width(nArray6[n9]);
                    nArray3[0] = Cairo.cairo_xlib_surface_get_height(nArray6[n9]);
                } else if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                    OS.gdk_pixmap_get_size(nArray6[n9], nArray2, nArray3);
                } else {
                    OS.gdk_drawable_get_size(nArray6[n9], nArray2, nArray3);
                }
                n10 = Math.max(n10, nArray2[0]);
                n11 = gdkRectangle.y + nArray3[0] - nArray4[0];
                nArray4[n9] = gdkRectangle.y;
                nArray5[n9] = nArray3[0];
                n3 = OS.g_list_next(n3);
                OS.gtk_tree_path_free(n8);
            }
            if (OS.GTK3) {
                n9 = Cairo.cairo_image_surface_create(0, n10, n11);
                if (n9 == 0) {
                    SWT.error(2);
                }
                if ((n8 = Cairo.cairo_create(n9)) == 0) {
                    SWT.error(2);
                }
                Cairo.cairo_set_operator(n8, 1);
                for (int i = 0; i < n4; ++i) {
                    Cairo.cairo_set_source_surface(n8, nArray6[i], 2.0, nArray4[i] - nArray4[0] + 2);
                    Cairo.cairo_rectangle(n8, 0.0, nArray4[i] - nArray4[0], n10, nArray5[i]);
                    Cairo.cairo_fill(n8);
                    Cairo.cairo_surface_destroy(nArray6[i]);
                }
                Cairo.cairo_destroy(n8);
                this.dragSourceImage = Image.gtk_new(display, 1, n9, 0);
            } else {
                n9 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n10, n11, -1);
                n8 = OS.gdk_gc_new(n9);
                int n12 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n10, n11, 1);
                int n13 = OS.gdk_gc_new(n12);
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = 0;
                OS.gdk_gc_set_foreground(n13, gdkColor);
                OS.gdk_draw_rectangle(n12, n13, 1, 0, 0, n10, n11);
                gdkColor.pixel = 1;
                OS.gdk_gc_set_foreground(n13, gdkColor);
                for (int i = 0; i < n4; ++i) {
                    OS.gdk_draw_drawable(n9, n8, nArray6[i], 0, 0, 0, nArray4[i] - nArray4[0], -1, -1);
                    OS.gdk_draw_rectangle(n12, n13, 1, 0, nArray4[i] - nArray4[0], n10, nArray5[i]);
                    OS.g_object_unref(nArray6[i]);
                }
                OS.g_object_unref(n8);
                OS.g_object_unref(n13);
                this.dragSourceImage = Image.gtk_new(display, 1, n9, n12);
            }
        }
        OS.g_list_free(n5);
        return this.dragSourceImage;
    }
}

