/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.control;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.ButtonToggleEvent;

public class ImageButton
extends GridPane {
    private final Label iconLabel;
    private ImageView icon;
    private ImageView hoverIcon;
    private ImageView pressIcon;
    private ImageView selectIcon;
    private ImageView selectHoverIcon;
    private ImageView selectPressIcon;
    protected EventHandler<? super MouseEvent> onMouseClick = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
        }
    };
    private EventHandler<ButtonToggleEvent> onSelected = new EventHandler<ButtonToggleEvent>(){

        public void handle(ButtonToggleEvent arg0) {
        }
    };
    protected final SimpleObjectProperty<BUTTON_STATE> stateProperty = new SimpleObjectProperty();
    boolean isToggleButton;
    boolean isSelected;

    public ImageButton(ImageView icon, ImageView overIcon, ImageView pressIcon) {
        this(icon, overIcon, pressIcon, pressIcon);
        this.isToggleButton = false;
    }

    public ImageButton(ImageView icon, ImageView overIcon, ImageView pressIcon, ImageView selectIcon) {
        this(icon, overIcon, pressIcon, selectIcon, selectIcon, selectIcon);
        this.isToggleButton = true;
    }

    public ImageButton(ImageView icon, ImageView overIcon, ImageView pressIcon, ImageView selectIcon, ImageView selectHoverIcon, ImageView selectPressIcon) {
        this.setAlignment(Pos.CENTER);
        this.iconLabel = new Label();
        this.add((Node)this.iconLabel, 0, 0);
        this.icon = icon;
        this.hoverIcon = overIcon;
        this.selectIcon = selectIcon;
        this.pressIcon = pressIcon;
        this.selectHoverIcon = selectHoverIcon;
        this.selectPressIcon = selectPressIcon;
        this.isSelected = false;
        this.stateProperty.set((Object)BUTTON_STATE.NORMAL);
        this.drawIcon();
        this.addMouseListener();
        this.addStateListener();
        this.isToggleButton = true;
    }

    protected void changeIcons(ImageView icon, ImageView hoverIcon, ImageView pressIcon, ImageView selectIcon) {
        if (icon != null) {
            this.icon = icon;
        }
        if (hoverIcon != null) {
            this.hoverIcon = hoverIcon;
        }
        if (pressIcon != null) {
            this.pressIcon = pressIcon;
        }
        if (selectIcon != null) {
            this.selectIcon = selectIcon;
            this.selectHoverIcon = selectIcon;
            this.selectPressIcon = selectIcon;
        }
        this.drawIcon();
    }

    public void setOnMouseClick(EventHandler<? super MouseEvent> handler) {
        this.onMouseClick = handler;
    }

    public void setOnSelected(EventHandler<ButtonToggleEvent> handler) {
        this.onSelected = handler;
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }

    protected void setSelected(boolean selected, boolean isHover) {
        if (!this.isToggleButton) {
            this.stateProperty.set((Object)(isHover ? BUTTON_STATE.HOVER : BUTTON_STATE.NORMAL));
            return;
        }
        if (this.isSelected == selected) {
            return;
        }
        this.isSelected = selected;
        BUTTON_STATE bState = selected ? (isHover ? BUTTON_STATE.SELECT_HOVER : BUTTON_STATE.SELECT_NORMAL) : (isHover ? BUTTON_STATE.HOVER : BUTTON_STATE.NORMAL);
        this.stateProperty.set((Object)bState);
        this.onSelected.handle((Event)new ButtonToggleEvent(this.isSelected));
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, false);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    private void addStateListener() {
        this.stateProperty.addListener((ChangeListener)new ChangeListener<BUTTON_STATE>(){

            public void changed(ObservableValue<? extends BUTTON_STATE> arg0, BUTTON_STATE arg1, BUTTON_STATE arg2) {
                ImageButton.this.drawIcon(arg2);
            }
        });
    }

    protected void drawIcon() {
        this.drawIcon((BUTTON_STATE)((Object)this.stateProperty.get()));
    }

    private void drawIcon(BUTTON_STATE state) {
        if (this.isFocused()) {
            if (this.isSelected) {
                this.iconLabel.setGraphic((Node)this.selectPressIcon);
            } else {
                this.iconLabel.setGraphic((Node)this.pressIcon);
            }
            return;
        }
        switch (state) {
            case NORMAL: {
                this.iconLabel.setGraphic((Node)this.icon);
                break;
            }
            case HOVER: {
                this.iconLabel.setGraphic((Node)this.hoverIcon);
                break;
            }
            case PRESS: {
                this.iconLabel.setGraphic((Node)this.pressIcon);
                break;
            }
            case SELECT_NORMAL: {
                this.iconLabel.setGraphic((Node)this.selectIcon);
                break;
            }
            case SELECT_HOVER: {
                this.iconLabel.setGraphic((Node)this.selectHoverIcon);
                break;
            }
            case SELECT_PRESS: {
                this.iconLabel.setGraphic((Node)this.selectPressIcon);
                break;
            }
        }
    }

    protected void buttonReleased() {
        this.setSelected(!this.isSelected, true);
    }

    private void addMouseListener() {
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                Bounds bound = ImageButton.this.getBoundsInLocal();
                if (e.getX() > 0.0 && e.getX() < bound.getWidth() && e.getY() > 0.0 && e.getY() < bound.getHeight()) {
                    ImageButton.this.buttonReleased();
                    ImageButton.this.onMouseClick.handle((Event)e);
                }
            }
        });
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ImageButton.this.stateProperty.set((Object)(ImageButton.this.isToggleButton && ImageButton.this.isSelected ? BUTTON_STATE.SELECT_PRESS : BUTTON_STATE.PRESS));
            }
        });
        this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ImageButton.this.stateProperty.set((Object)(ImageButton.this.isToggleButton && ImageButton.this.isSelected ? BUTTON_STATE.SELECT_HOVER : BUTTON_STATE.HOVER));
            }
        });
        this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ImageButton.this.stateProperty.set((Object)(ImageButton.this.isToggleButton && ImageButton.this.isSelected ? BUTTON_STATE.SELECT_NORMAL : BUTTON_STATE.NORMAL));
            }
        });
    }

    public void setTooltipText(String tooltip) {
        this.iconLabel.setTooltip(new Tooltip(tooltip));
    }

    static enum BUTTON_STATE {
        NORMAL,
        HOVER,
        PRESS,
        SELECT_NORMAL,
        SELECT_HOVER,
        SELECT_PRESS;

    }
}

