/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.control;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.tizen.ecp.control.ImageButton;

class SpinnerArrowButton
extends ImageButton {
    private EventHandler<? super ActionEvent> onActionEvent = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
        }
    };
    private static final double INITIAL_DURATION_MS = 250.0;
    private Timeline timeline;
    final EventHandler<ActionEvent> spinningKeyFrameEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            SpinnerArrowButton.this.onActionEvent.handle((Event)event);
        }
    };

    public SpinnerArrowButton(ImageView icon, ImageView overIcon, ImageView pressIcon) {
        super(icon, overIcon, pressIcon);
        this.getStyleClass().add((Object)"tizen-arrow-button");
        this.addListener();
    }

    private void addListener() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                SpinnerArrowButton.this.stateProperty.set((Object)(SpinnerArrowButton.this.isToggleButton && SpinnerArrowButton.this.isSelected ? ImageButton.BUTTON_STATE.SELECT_PRESS : ImageButton.BUTTON_STATE.PRESS));
                SpinnerArrowButton.this.requestFocus();
                SpinnerArrowButton.this.startSpinning();
            }
        });
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                SpinnerArrowButton.this.requestFocus();
                SpinnerArrowButton.this.stopSpinning();
                SpinnerArrowButton.this.setFocused(false);
                SpinnerArrowButton.this.buttonReleased();
                Bounds bound = SpinnerArrowButton.this.getBoundsInLocal();
                if (e.getX() > 0.0 && e.getX() < bound.getWidth() && e.getY() > 0.0 && e.getY() < bound.getHeight()) {
                    SpinnerArrowButton.this.onMouseClick.handle((Event)e);
                }
            }
        });
    }

    public void setOnActionEvent(EventHandler<? super ActionEvent> onActionEvent) {
        this.onActionEvent = onActionEvent;
    }

    private void startSpinning() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        KeyFrame kf = new KeyFrame(Duration.millis((double)250.0), this.spinningKeyFrameEventHandler, new KeyValue[0]);
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf});
        this.timeline.playFromStart();
        this.timeline.play();
    }

    private void stopSpinning() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }
}

