/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.control;

import com.sun.javafx.scene.control.behavior.SliderBehavior;
import com.sun.javafx.scene.control.skin.SliderSkin;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class TizenSliderSkin
extends SliderSkin {
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;
    private boolean trackClicked = false;
    private static double THUMB_WIDTH = 11.0;
    private static double THUMB_HEIGHT = 22.0;
    private static double TRACK_HEIGHT = 24.0;
    StringConverter<Number> stringConverterWrapper = new StringConverter<Number>(){
        Slider slider;
        {
            this.slider = (Slider)TizenSliderSkin.this.getSkinnable();
        }

        public String toString(Number object) {
            if (object == null) {
                return "";
            }
            StringConverter formatter = this.slider.getLabelFormatter();
            if (formatter == null) {
                return "";
            }
            return formatter.toString((Object)object.doubleValue());
        }

        public Number fromString(String string) {
            StringConverter formatter = this.slider.getLabelFormatter();
            if (formatter == null) {
                return null;
            }
            return (Number)formatter.fromString(string);
        }
    };

    public TizenSliderSkin(Slider slider) {
        super(slider);
        this.initialize();
        slider.requestLayout();
        this.registerChangeListener((ObservableValue)slider.minProperty(), "MIN");
        this.registerChangeListener((ObservableValue)slider.maxProperty(), "MAX");
        this.registerChangeListener((ObservableValue)slider.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)slider.orientationProperty(), "ORIENTATION");
    }

    private void initialize() {
        this.thumb = new StackPane();
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setPrefSize(THUMB_WIDTH, THUMB_HEIGHT);
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.track.setPrefHeight(TRACK_HEIGHT);
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.thumb});
        this.track.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!TizenSliderSkin.this.thumb.isPressed()) {
                    TizenSliderSkin.this.trackClicked = true;
                    ((SliderBehavior)TizenSliderSkin.this.getBehavior()).trackPress(event, event.getX() / TizenSliderSkin.this.trackLength);
                    TizenSliderSkin.this.trackClicked = false;
                }
            }
        });
        this.track.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!TizenSliderSkin.this.thumb.isPressed()) {
                    ((SliderBehavior)TizenSliderSkin.this.getBehavior()).trackPress(event, event.getX() / TizenSliderSkin.this.trackLength);
                }
            }
        });
        this.thumb.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                ((SliderBehavior)TizenSliderSkin.this.getBehavior()).thumbPressed(me, 0.0);
                TizenSliderSkin.this.dragStart = TizenSliderSkin.this.thumb.localToParent(me.getX(), me.getY());
                TizenSliderSkin.this.preDragThumbPos = (((Slider)TizenSliderSkin.this.getSkinnable()).getValue() - ((Slider)TizenSliderSkin.this.getSkinnable()).getMin()) / (((Slider)TizenSliderSkin.this.getSkinnable()).getMax() - ((Slider)TizenSliderSkin.this.getSkinnable()).getMin());
            }
        });
        this.thumb.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                ((SliderBehavior)TizenSliderSkin.this.getBehavior()).thumbReleased(me);
            }
        });
        this.thumb.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                Point2D cur = TizenSliderSkin.this.thumb.localToParent(me.getX(), me.getY());
                double dragPos = cur.getX() - TizenSliderSkin.this.dragStart.getX();
                ((SliderBehavior)TizenSliderSkin.this.getBehavior()).thumbDragged(me, TizenSliderSkin.this.preDragThumbPos + dragPos / TizenSliderSkin.this.trackLength);
            }
        });
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ORIENTATION".equals(p)) {
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("VALUE".equals(p)) {
            this.positionThumb2(this.trackClicked);
        } else if ("MIN".equals(p)) {
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("MAX".equals(p)) {
            ((Slider)this.getSkinnable()).requestLayout();
        }
    }

    private void positionThumb2(boolean animate) {
        double end;
        Slider s = (Slider)this.getSkinnable();
        if (s.getValue() > s.getMax()) {
            return;
        }
        final double endX = end = this.trackStart + this.thumbWidth + ((this.trackLength - this.thumbWidth) * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin())) - this.thumbWidth);
        final double endY = this.thumbTop;
        if (animate) {
            final double startX = this.thumb.getLayoutX();
            final double startY = this.thumb.getLayoutY();
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)200.0));
                }

                protected void interpolate(double frac) {
                    if (!Double.isNaN(startX)) {
                        TizenSliderSkin.this.thumb.setLayoutX(startX + frac * (endX - startX));
                    }
                    if (!Double.isNaN(startY)) {
                        TizenSliderSkin.this.thumb.setLayoutY(startY + frac * (endY - startY));
                    }
                }
            };
            transition.play();
        } else {
            this.thumb.setLayoutX(endX);
            this.thumb.setLayoutY(endY);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double trackAreaHeight;
        this.thumbWidth = this.snapSize(THUMB_WIDTH);
        this.thumbHeight = this.snapSize(THUMB_HEIGHT);
        this.thumb.resize(this.thumbWidth, this.thumbHeight);
        double trackHeight = this.snapSize(TRACK_HEIGHT);
        double totalHeightNeeded = trackAreaHeight = Math.max(trackHeight, this.thumbHeight);
        double startY = y + (h - totalHeightNeeded) / 2.0;
        this.trackLength = this.snapSize(w);
        this.trackStart = this.snapPosition(x);
        double trackTop = (int)(startY + (trackAreaHeight - trackHeight) / 2.0);
        this.thumbTop = (int)(startY + (trackAreaHeight - this.thumbHeight) / 2.0);
        this.positionThumb2(false);
        this.track.resizeRelocate((double)((int)this.trackStart), trackTop, (double)((int)this.trackLength), trackHeight);
    }
}

