/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.tizen.ecp.EmulatorControlPanel;
import org.tizen.ecp.about.About;
import org.tizen.ecp.device.DeviceManager;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.Dialog;
import org.tizen.ecp.dialog.shortcut.ShortcutSelectionDialog;
import org.tizen.ecp.resources.FontKind;
import org.tizen.ecp.resources.Fonts;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPPageNavigator;
import org.tizen.ecp.views.card.ECPCardPane;

public class ECPMainAction
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(ECPMainAction.class).getLogger();
    @FXML
    private Button btnAbout;
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private TilePane tilePane;
    @FXML
    private TilePane borderPane;
    @FXML
    private TilePane leftPane;
    @FXML
    private TilePane rightPane;
    @FXML
    private StackPane stackPane;
    @FXML
    private ImageView ecpBackground;
    @FXML
    private Label ecpTitle;
    @FXML
    private Label tizenTitle;
    @FXML
    private Pane fxNavigatorBar;
    @FXML
    private Button fxPreviousBtn;
    @FXML
    private Button fxNextBtn;
    @FXML
    private HBox fxNavigatorPane;
    @FXML
    private Label prevShortcut;
    @FXML
    private Label nextShortcut;
    ECPPageNavigator pageNavigator;
    StackPane pane;
    private double tileWidth = 0.0;
    private double tileHeight = 0.0;
    private final List<ECPCardPane> cardPanes = new ArrayList<ECPCardPane>();
    private static final String PREV_SHORTCUT_CHAR = "<";
    private static final String NEXT_SHORTCUT_CHAR = ">";
    private static BooleanProperty shortcutVisible = new SimpleBooleanProperty(false);
    int wCount;
    int hCount;
    ChangeListener<Number> tileSizeListener = (observable, oldValue, newValue) -> {
        int pageCount = 0;
        this.wCount = (int)(this.tilePane.getWidth() / this.tileWidth);
        this.hCount = (int)(this.tilePane.getHeight() / this.tileHeight);
        int viewCount = this.wCount * this.hCount;
        if (viewCount != 0) {
            pageCount = this.cardPanes.size() / viewCount + (this.cardPanes.size() % viewCount != 0 ? 1 : 0);
            this.pageNavigator.setItem(pageCount, 0);
        } else {
            this.pageNavigator.setItem(1, 0);
        }
    };
    private static final int SWIPE_DURATION = 200;
    private static final int TRANSITION_DURATION = 200;
    private boolean pressed = false;
    private boolean onSwipe = false;
    private double posX = 0.0;
    private double posY = 0.0;
    private double leftPosX = 0.0;
    private double rightPosX = 0.0;
    private double tempTileWidth = 0.0;
    private double tempTileHeight = 0.0;
    private static final double SPACE_BETWEEN_PANES = 10.0;
    private static final int DRAG_DIST = 200;
    private static int MAX_PAGE = 0;

    public static BooleanProperty shortcutVisibleProperty() {
        return shortcutVisible;
    }

    public void initialize(URL location, ResourceBundle resources) {
        try {
            String width = EmulatorControlPanel.getECPProperty().getPropertyString("card.width");
            this.tileWidth = width != null ? Double.parseDouble(width) : 161.0;
            String height = EmulatorControlPanel.getECPProperty().getPropertyString("card.height");
            this.tileHeight = height != null ? Double.parseDouble(height) : 171.0;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Property file does not contain card size", e);
            e.printStackTrace();
            this.tileWidth = 161.0;
            this.tileHeight = 171.0;
        }
        this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_NOR));
        GridPane.setMargin((Node)this.btnAbout, (Insets)new Insets(0.0, 20.0, 20.0, 0.0));
        this.ecpTitle.setFont(Fonts.get(FontKind.FONT_38_BOLD));
        this.tizenTitle.setFont(Fonts.get(FontKind.FONT_21));
        List<String> devices = DeviceManager.getInstance().getDeviceList();
        for (String device : devices) {
            ECPCardPane ecpPane = DeviceManager.getInstance().getDevice(device);
            if (ecpPane == null) continue;
            ecpPane.createView();
            ecpPane.onCreate();
            this.cardPanes.add(ecpPane);
        }
        this.tilePane.widthProperty().addListener(this.tileSizeListener);
        this.tilePane.heightProperty().addListener(this.tileSizeListener);
        this.ecpBackground.setImage(Images.getImageView(ImageKind.ECP_TOP_BG).getImage());
        this.fxNavigatorBar.getStylesheets().add((Object)this.getClass().getResource("resources/navigator.css").toExternalForm());
        this.fxPreviousBtn.getStyleClass().addAll((Object[])new String[]{"navigator-button", "previous-button"});
        this.fxNextBtn.getStyleClass().addAll((Object[])new String[]{"navigator-button", "next-button"});
        this.pageNavigator = new ECPPageNavigator((Pane)this.fxNavigatorPane, this.fxPreviousBtn, this.fxNextBtn);
        this.pageNavigator.setItem(1, 0);
        this.pageNavigator.addPageChangedListener((page, selected) -> {
            int wCount = (int)(this.tilePane.getWidth() / this.tileWidth);
            int hCount = (int)(this.tilePane.getHeight() / this.tileHeight);
            int viewCount = wCount * hCount;
            this.tilePane.getChildren().clear();
            this.borderPane.getChildren().clear();
            for (int i = 0; i < this.cardPanes.size(); ++i) {
                if (i < viewCount * selected || i >= viewCount * (selected + 1)) continue;
                AnchorPane border = new AnchorPane();
                border.setStyle("-fx-background-color: #acacac;");
                this.borderPane.getChildren().add((Object)border);
                ECPCardPane cardPane = this.cardPanes.get(i);
                Pane pane = cardPane.getCardAction().getRootPane();
                TilePane.setMargin((Node)pane, (Insets)new Insets(0.0, 1.0, 1.0, 0.0));
                this.tilePane.getChildren().add((Object)pane);
            }
            this.checkPrevNextShortcut();
        });
        this.prevShortcut.setText(PREV_SHORTCUT_CHAR);
        this.nextShortcut.setText(NEXT_SHORTCUT_CHAR);
        this.prevShortcut.getStyleClass().add((Object)"shortcut");
        this.nextShortcut.getStyleClass().add((Object)"shortcut");
        shortcutVisible.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue == null) {
                    return;
                }
                ECPMainAction.this.checkPrevNextShortcut();
            }
        });
        this.stackPane.setOnKeyPressed(event -> {
            if (event.isAltDown()) {
                return;
            }
            KeyCode keyCode = event.getCode();
            switch (keyCode) {
                case LEFT: {
                    this.changeFocus(Direction.LEFT);
                    event.consume();
                    break;
                }
                case RIGHT: {
                    this.changeFocus(Direction.RIGHT);
                    event.consume();
                    break;
                }
                case UP: {
                    this.changeFocus(Direction.UP);
                    event.consume();
                    break;
                }
                case DOWN: {
                    this.changeFocus(Direction.DOWN);
                    event.consume();
                    break;
                }
            }
        });
        this.rightPane.setVisible(false);
        this.leftPane.setVisible(false);
        this.rootAnchor.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                if (keyCode == KeyCode.ALT) {
                    ECPMainAction.this.setShortcutVisible(true);
                }
                if (event.isAltDown() && keyCode != KeyCode.ALT) {
                    boolean showShortCut = false;
                    if (keyCode == KeyCode.COMMA || keyCode == KeyCode.LEFT) {
                        ECPMainAction.this.prevPage(-1);
                        showShortCut = true;
                    } else if (keyCode == KeyCode.PERIOD || keyCode == KeyCode.RIGHT) {
                        ECPMainAction.this.nextPage(-1);
                        showShortCut = true;
                    } else {
                        showShortCut = !ECPMainAction.this.shortcutPressed(keyCode);
                    }
                    ECPMainAction.this.setShortcutVisible(showShortCut);
                }
            }
        });
        this.rootAnchor.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                int focusIndex = ECPMainAction.this.findFocusedCardIndex();
                switch (keyCode) {
                    case PAGE_DOWN: {
                        if (!ECPMainAction.this.pageNavigator.nextPage()) break;
                        ECPMainAction.this.setFocus(focusIndex);
                        break;
                    }
                    case PAGE_UP: {
                        if (!ECPMainAction.this.pageNavigator.prevPage()) break;
                        ECPMainAction.this.setFocus(focusIndex);
                        break;
                    }
                }
            }
        });
        this.rootAnchor.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                if (keyCode == KeyCode.ALT) {
                    ECPMainAction.this.setShortcutVisible(false);
                }
            }
        });
        EmulatorControlPanel.getMainStage().focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isFocused) {
                if (!isFocused.booleanValue()) {
                    ECPMainAction.this.setShortcutVisible(false);
                }
            }
        });
    }

    private void checkPrevNextShortcut() {
        if (shortcutVisible.get()) {
            this.nextShortcut.setVisible(true);
            this.prevShortcut.setVisible(true);
            if (this.pageNavigator.isFirstPage()) {
                this.prevShortcut.setVisible(false);
            }
            if (this.pageNavigator.isLastPage()) {
                this.nextShortcut.setVisible(false);
            }
        } else {
            this.prevShortcut.setVisible(false);
            this.nextShortcut.setVisible(false);
        }
    }

    private void setShortcutVisible(boolean isVisible) {
        shortcutVisible.set(isVisible);
    }

    private boolean shortcutPressed(KeyCode code) {
        ArrayList<ECPCardPane> list = new ArrayList<ECPCardPane>();
        for (ECPCardPane ecpPane : this.cardPanes) {
            if (!code.getName().equalsIgnoreCase(ecpPane.getShortcut()) || ecpPane.getDrawPane().isDisable()) continue;
            list.add(ecpPane);
        }
        if (list.size() == 0) {
            return false;
        }
        ECPCardPane selectedCard = null;
        if (list.size() == 1) {
            selectedCard = (ECPCardPane)list.get(0);
        } else if (list.size() > 1) {
            selectedCard = new ShortcutSelectionDialog(list).open();
        }
        if (selectedCard != null) {
            int cardIndex = this.getCardIndex(selectedCard);
            if (cardIndex > -1) {
                int viewCount = this.wCount * this.hCount;
                int currentPage = this.pageNavigator.getItempage();
                int moveToPage = cardIndex / viewCount;
                int pageDiff = moveToPage - currentPage;
                for (int i = 0; i < Math.abs(pageDiff); ++i) {
                    int focusIndex = cardIndex % viewCount;
                    if (pageDiff > 0) {
                        this.nextPage(focusIndex);
                        continue;
                    }
                    this.prevPage(focusIndex);
                }
            }
            selectedCard.getCardAction().selectCard();
        }
        return true;
    }

    private int getCardIndex(ECPCardPane card) {
        for (int i = 0; i < this.cardPanes.size(); ++i) {
            if (!this.cardPanes.get(i).equals(card)) continue;
            return i;
        }
        return -1;
    }

    private int findCurrentCardIndex() {
        for (int i = 0; i < this.cardPanes.size(); ++i) {
            if (!this.cardPanes.get(i).getDrawPane().isFocused()) continue;
            return i;
        }
        return 0;
    }

    private void changeFocus(Direction direction) {
        ECPCardPane nextCard;
        int moveCount = 1;
        while ((nextCard = this.findNextCard(direction, moveCount++)) != null && nextCard.getDrawPane().isDisable()) {
        }
        if (nextCard == null) {
            return;
        }
        int cardIndex = this.getCardIndex(nextCard);
        if (cardIndex == -1) {
            return;
        }
        int viewCount = this.wCount * this.hCount;
        this.pageNavigator.movePage(cardIndex / viewCount);
        nextCard.getDrawPane().requestFocus();
    }

    private void setFocus(int focusIndex) {
        int cardNum = this.tilePane.getChildren().size();
        if (focusIndex < cardNum && focusIndex >= 0 && !((Node)this.tilePane.getChildren().get(focusIndex)).isDisabled()) {
            ((Node)this.tilePane.getChildren().get(focusIndex)).requestFocus();
        } else {
            for (Node node : this.tilePane.getChildren()) {
                if (node.isDisabled()) continue;
                node.requestFocus();
                return;
            }
        }
    }

    private ECPCardPane findNextCard(Direction direction, int count) {
        int viewCount;
        int currentPage;
        int index = this.findCurrentCardIndex();
        boolean doNotMovePage = false;
        if (direction == Direction.LEFT) {
            index += -1 * count;
        } else if (direction == Direction.RIGHT) {
            index += 1 * count;
        } else if (direction == Direction.UP) {
            index += -this.wCount * count;
            doNotMovePage = true;
        } else if (direction == Direction.DOWN) {
            index += this.wCount * count;
            doNotMovePage = true;
        }
        if (doNotMovePage && (index < (currentPage = this.pageNavigator.getItempage()) * (viewCount = this.hCount * this.wCount) || index >= (currentPage + 1) * viewCount)) {
            return null;
        }
        if (index >= 0 && index < this.cardPanes.size()) {
            return this.cardPanes.get(index);
        }
        return null;
    }

    private int findFocusedCardIndex() {
        int index = 0;
        for (int i = 0; i < this.tilePane.getChildren().size(); ++i) {
            if (!((Node)this.tilePane.getChildren().get(i)).isFocused()) continue;
            index = i;
            break;
        }
        return index;
    }

    @FXML
    void clickPreviousBtn(ActionEvent event) {
        this.prevPage(-1);
    }

    @FXML
    void clickNextBtn(ActionEvent event) {
        this.nextPage(-1);
    }

    private boolean prevPage(int focusIndex) {
        if (this.pageNavigator.isFirstPage()) {
            return false;
        }
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        int wCount = (int)(this.tilePane.getWidth() / this.tileWidth);
        int hCount = (int)(this.tilePane.getHeight() / this.tileHeight);
        this.createOnLeftPaneForSwipe(wCount * hCount, this.pageNavigator.getItempage());
        this.leftPane.setVisible(true);
        this.leftPane.setTranslateX(-this.leftPane.getWidth() - 10.0);
        KeyValue keyRight = new KeyValue((WritableValue)this.leftPane.translateXProperty(), (Object)0);
        KeyValue keyTile = new KeyValue((WritableValue)this.tilePane.translateXProperty(), (Object)this.tilePane.getWidth());
        KeyValue keyBorder = new KeyValue((WritableValue)this.borderPane.translateXProperty(), (Object)this.borderPane.getWidth());
        Duration duration = Duration.millis((double)200.0);
        EventHandler onFinished = t -> {
            this.pageNavigator.prevPage();
            this.leftPane.setVisible(false);
            this.tilePane.setTranslateX(0.0);
            this.borderPane.setTranslateX(0.0);
            if (focusIndex >= 0) {
                this.setFocus(focusIndex);
            }
        };
        KeyFrame keyFrame = new KeyFrame(duration, onFinished, new KeyValue[]{keyTile, keyBorder, keyRight});
        timeline.getKeyFrames().add((Object)keyFrame);
        timeline.play();
        return true;
    }

    private boolean nextPage(int focusIndex) {
        if (this.pageNavigator.isLastPage()) {
            return false;
        }
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        int wCount = (int)(this.tilePane.getWidth() / this.tileWidth);
        int hCount = (int)(this.tilePane.getHeight() / this.tileHeight);
        this.createOnRightPaneForSwipe(wCount * hCount, this.pageNavigator.getItempage());
        this.rightPane.setVisible(true);
        this.rightPane.setTranslateX(this.rightPane.getWidth() + 10.0);
        KeyValue keyRight = new KeyValue((WritableValue)this.rightPane.translateXProperty(), (Object)0);
        KeyValue keyTile = new KeyValue((WritableValue)this.tilePane.translateXProperty(), (Object)(-this.tilePane.getWidth()));
        KeyValue keyBorder = new KeyValue((WritableValue)this.borderPane.translateXProperty(), (Object)(-this.borderPane.getWidth()));
        Duration duration = Duration.millis((double)200.0);
        EventHandler onFinished = t -> {
            this.pageNavigator.nextPage();
            this.rightPane.setVisible(false);
            this.tilePane.setTranslateX(0.0);
            this.borderPane.setTranslateX(0.0);
            if (focusIndex >= 0) {
                this.setFocus(focusIndex);
            }
        };
        KeyFrame keyFrame = new KeyFrame(duration, onFinished, new KeyValue[]{keyTile, keyBorder, keyRight});
        timeline.getKeyFrames().add((Object)keyFrame);
        timeline.play();
        return true;
    }

    @FXML
    public void tileMouseEvent(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.pollBackPanes();
            this.pressed = true;
            this.onSwipe = false;
            this.posX = event.getSceneX();
            this.posY = event.getSceneY();
            this.rightPosX = this.posX - this.rightPane.getWidth();
            this.leftPosX = this.posX + this.leftPane.getWidth();
            this.tempTileWidth = this.tilePane.getWidth();
            this.tempTileHeight = this.tilePane.getHeight();
        } else if (event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
            if (this.pressed) {
                double presentX = event.getX();
                double diff = presentX - this.posX;
                this.tilePane.setTranslateX(diff);
                this.borderPane.setTranslateX(diff);
                if (presentX > this.posX) {
                    this.leftPane.setTranslateX(event.getX() - this.leftPosX - 10.0);
                } else {
                    this.rightPane.setTranslateX(event.getX() - this.rightPosX + 10.0);
                }
                if (!this.onSwipe) {
                    int wCount = (int)(this.tilePane.getWidth() / this.tileWidth);
                    int hCount = (int)(this.tilePane.getHeight() / this.tileHeight);
                    int viewCount = wCount * hCount;
                    MAX_PAGE = this.cardPanes.size() % viewCount == 0 ? this.cardPanes.size() / viewCount : this.cardPanes.size() / viewCount + 1;
                    if (presentX > this.posX) {
                        this.createOnLeftPaneForSwipe(viewCount, this.pageNavigator.getItempage());
                    } else {
                        this.createOnRightPaneForSwipe(viewCount, this.pageNavigator.getItempage());
                    }
                    this.onSwipe = true;
                }
            }
        } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED && this.pressed) {
            double diffX = event.getSceneX() - this.posX;
            double diffY = event.getSceneY() - this.posY;
            event.consume();
            this.pressed = false;
            if (diffX < -200.0) {
                this.nextPageAnimation();
            } else if (diffX > 200.0) {
                this.prevPageAnimation();
            } else if (diffY < -200.0) {
                this.pageNavigator.nextPage();
            } else if (diffY > 200.0) {
                this.pageNavigator.prevPage();
            } else {
                this.pollBackPanes();
            }
        }
        if (event.getEventType() == MouseEvent.MOUSE_CLICKED && this.rootAnchor.getChildren().size() > 1) {
            this.rootAnchor.getChildren().remove(1);
        }
    }

    void prevPageAnimation() {
        if (this.pageNavigator.getItempage() != 0) {
            Timeline timeline = new Timeline();
            timeline.setCycleCount(1);
            KeyValue keyRight = new KeyValue((WritableValue)this.leftPane.translateXProperty(), (Object)0);
            KeyValue keyTile = new KeyValue((WritableValue)this.tilePane.translateXProperty(), (Object)this.tilePane.getWidth());
            KeyValue keyBorder = new KeyValue((WritableValue)this.borderPane.translateXProperty(), (Object)this.borderPane.getWidth());
            Duration duration = Duration.millis((double)200.0);
            EventHandler onFinished = t -> {
                this.pageNavigator.prevPage();
                this.pollBackPanes();
            };
            KeyFrame keyFrame = new KeyFrame(duration, onFinished, new KeyValue[]{keyTile, keyBorder, keyRight});
            timeline.getKeyFrames().add((Object)keyFrame);
            timeline.play();
        } else {
            this.pollBackPanes();
        }
    }

    void nextPageAnimation() {
        if (MAX_PAGE - 1 != this.pageNavigator.getItempage()) {
            Timeline timeline = new Timeline();
            timeline.setCycleCount(1);
            KeyValue keyRight = new KeyValue((WritableValue)this.rightPane.translateXProperty(), (Object)0);
            KeyValue keyTile = new KeyValue((WritableValue)this.tilePane.translateXProperty(), (Object)(-this.tilePane.getWidth()));
            KeyValue keyBorder = new KeyValue((WritableValue)this.borderPane.translateXProperty(), (Object)(-this.borderPane.getWidth()));
            Duration duration = Duration.millis((double)200.0);
            EventHandler onFinished = t -> {
                this.pageNavigator.nextPage();
                this.pollBackPanes();
            };
            KeyFrame keyFrame = new KeyFrame(duration, onFinished, new KeyValue[]{keyTile, keyBorder, keyRight});
            timeline.getKeyFrames().add((Object)keyFrame);
            timeline.play();
        } else {
            this.pollBackPanes();
        }
    }

    void pollBackPanes() {
        this.tilePane.setTranslateX(0.0);
        this.tilePane.setPrefWidth(this.tempTileWidth);
        this.tilePane.setPrefHeight(this.tempTileHeight);
        this.borderPane.setTranslateX(0.0);
        this.leftPane.setVisible(false);
        this.rightPane.setVisible(false);
        this.rightPane.getChildren().clear();
        this.leftPane.getChildren().clear();
        this.leftPane.setTranslateX(0.0);
        this.rightPane.setTranslateX(0.0);
    }

    void createOnLeftPaneForSwipe(int viewCount, int pagePos) {
        if (pagePos != 0) {
            int leftStart;
            this.leftPane.setVisible(true);
            this.leftPane.setTranslateX(this.leftPosX - 10.0);
            this.leftPane.getChildren().clear();
            for (int i = leftStart = (pagePos - 1) * viewCount; i < leftStart + viewCount; ++i) {
                AnchorPane border = new AnchorPane();
                border.setStyle("-fx-background-color: #acacac;");
                Pane pane = this.cardPanes.get(i).getCardAction().getRootPane();
                this.leftPane.getChildren().add((Object)pane);
            }
        }
    }

    void createOnRightPaneForSwipe(int viewCount, int pagePos) {
        if (MAX_PAGE - 1 != pagePos) {
            this.rightPane.setVisible(true);
            this.rightPane.setTranslateX(this.rightPosX + 10.0);
            this.rightPane.getChildren().clear();
            int rightStart = (pagePos + 1) * viewCount;
            int rightEnd = Math.min(rightStart + viewCount, this.cardPanes.size());
            for (int i = rightStart; i < rightEnd; ++i) {
                AnchorPane border = new AnchorPane();
                border.setStyle("-fx-background-color: #acacac;");
                Pane pane = this.cardPanes.get(i).getCardAction().getRootPane();
                this.rightPane.getChildren().add((Object)pane);
            }
        }
    }

    @FXML
    void clickAboutButton(ActionEvent event) {
        Dialog dialog = new Dialog();
        dialog.setTitle("About Emulator Control Panel");
        dialog.addButonType(ButtonType.CLOSE);
        ECPFXMLLoader loader = new ECPFXMLLoader(this.getClass().getResource("/org/tizen/ecp/about/AboutView.fxml"), new Object[0]);
        VBox content = null;
        try {
            content = (VBox)loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        if (content == null) {
            About about = About.getInstance();
            String contents = "Version: " + about.getAboutVersion() + StringResources.NEW_LINE + "Build time: " + about.getBuildTime() + " (GMT)" + StringResources.NEW_LINE + "Git version: " + about.getGitVersion() + StringResources.NEW_LINE + "Workspace path: " + about.getWorkspacePath() + StringResources.NEW_LINE + "Package version: " + about.getEcpVersion();
            dialog.setContentText(contents);
        } else {
            AnchorPane pane = new AnchorPane();
            pane.getChildren().add((Object)content);
            AnchorPane.setLeftAnchor((Node)content, (Double)-1.0);
            AnchorPane.setRightAnchor((Node)content, (Double)-1.0);
            AnchorPane.setTopAnchor((Node)content, (Double)-1.0);
            dialog.getDialogPane().setContent((Node)pane);
            content.autosize();
        }
        Button button = dialog.getDialogPane().getButton(ButtonType.CLOSE);
        if (button != null) {
            button.requestFocus();
            button.setDefaultButton(true);
        }
        dialog.setResizable(false);
        dialog.showAndWait();
    }

    @FXML
    public void aboutButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_PRESS));
        } else {
            this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_NOR));
        }
    }

    static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

