/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.tizen.emulator.manager.device.xml.template.Device;
import org.tizen.emulator.manager.device.xml.template.DeviceConfiguration;
import org.tizen.emulator.manager.device.xml.template.DeviceItem;
import org.tizen.emulator.manager.device.xml.template.DeviceItemValue;
import org.tizen.emulator.manager.device.xml.template.DeviceValue;
import org.tizen.emulator.manager.device.xml.template.ObjectFactory;
import org.tizen.emulator.manager.devices.DeviceTemplatePriority;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.devices.DeviceWorkerException;
import org.tizen.emulator.manager.devices.SubDevice;
import org.tizen.emulator.manager.devices.SubDeviceItem;
import org.tizen.emulator.manager.devices.SubDeviceValue;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class DeviceTemplate
implements Comparable<DeviceTemplate> {
    private File templateFile;
    private long lastModified = 0L;
    private DeviceConfiguration conf;
    private DeviceTemplateValue value;

    public DeviceTemplate() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceTemplate)) {
            return false;
        }
        DeviceTemplate template = (DeviceTemplate)obj;
        return this.templateFile.equals(template.getTemplateFile()) || this.getValue().getName().equals(template.getValue().getName());
    }

    public DeviceTemplate(File file, DeviceConfiguration conf) {
        this.templateFile = file;
        this.lastModified = file.lastModified();
        this.conf = conf;
    }

    public void reloadDeviceTemplate() {
        DeviceTemplateUtil.reloadDeviceConfiguration(this);
        this.lastModified = this.templateFile.lastModified();
        this.settingDeviceTemplateValue(this.value);
    }

    public DeviceTemplateValue getValue() {
        if (this.value == null) {
            this.value = new DeviceTemplateValue(this);
            this.settingDeviceTemplateValue(this.value);
        }
        return this.value;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File propertyFile) {
        this.templateFile = propertyFile;
    }

    public DeviceConfiguration getConf() {
        return this.conf;
    }

    public void setConf(DeviceConfiguration conf) {
        this.conf = conf;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void delete() throws DeviceWorkerException {
        if (!this.templateFile.exists()) {
            throw new DeviceWorkerException("Failed to delete device template" + StringResources.NEW_LINE + "Device template file does not exist: " + StringResources.NEW_LINE + this.templateFile.getAbsolutePath(), true);
        }
        if (!this.templateFile.delete()) {
            throw new DeviceWorkerException("Failed to delete device template" + StringResources.NEW_LINE + "Check your device template file: " + StringResources.NEW_LINE + this.templateFile.getAbsolutePath());
        }
    }

    public void modify(DeviceTemplateValue newValue) throws DeviceWorkerException {
        if (this.value.equals(newValue)) {
            return;
        }
        if (!this.modifyDeviceConfiguration(newValue)) {
            throw new DeviceWorkerException("Failed to modfiy device template" + StringResources.NEW_LINE + "Check emulator manager log file: " + StringResources.NEW_LINE + FilePathResources.getTizenSDKDataVmsPath());
        }
    }

    public void create(DeviceTemplateValue newValue, String saveDir) throws DeviceWorkerException {
        if (newValue == null) {
            return;
        }
        newValue.setTemplate(this);
        if (!this.saveDeviceConfiguration(newValue, saveDir)) {
            throw new DeviceWorkerException("Failed to create device template" + StringResources.NEW_LINE + "Check emulator manager log file: " + StringResources.NEW_LINE + FilePathResources.getTizenSDKDataVmsPath());
        }
    }

    private boolean modifyDeviceConfiguration(DeviceTemplateValue newValue) {
        DeviceConfiguration newConf = this.settingConfiguration(newValue);
        if (newConf == null) {
            return false;
        }
        if (DeviceTemplateUtil.saveDeviceConfiguration(newConf, this.templateFile)) {
            this.conf = newConf;
            this.value = newValue;
            this.settingDeviceTemplateValue(this.value);
            this.lastModified = this.templateFile.lastModified();
            return true;
        }
        return false;
    }

    private boolean saveDeviceConfiguration(DeviceTemplateValue newValue, String saveDir) {
        String filePath = saveDir + File.separator + newValue.getName() + ".xml";
        this.templateFile = new File(filePath);
        return this.modifyDeviceConfiguration(newValue);
    }

    private DeviceConfiguration settingConfiguration(DeviceTemplateValue value) {
        ObjectFactory factory = new ObjectFactory();
        DeviceConfiguration conf = factory.createDeviceConfiguration();
        conf.setBaseInformation(factory.createBaseInformation());
        conf.setDisplay(factory.createDisplay());
        conf.setRam(factory.createRam());
        conf.setCpu(factory.createCpu());
        conf.getBaseInformation().setName(value.getName());
        conf.getBaseInformation().setType(value.getType().toString());
        conf.getBaseInformation().setProfile(value.getProfile());
        if (value.getExtenstion() != null && !value.getExtenstion().isEmpty()) {
            conf.getBaseInformation().setExtension(value.getExtenstion());
        }
        conf.getBaseInformation().setVersion(value.getVersion());
        conf.getBaseInformation().setPriority(value.getPriority().getValue());
        if (value.getManufacturer() != null && !value.getManufacturer().isEmpty()) {
            conf.getBaseInformation().setManufacturer(value.getManufacturer());
        }
        conf.getDisplay().setResolution(factory.createDisplayResolution());
        conf.getDisplay().getResolution().setWidth(value.getDisplayWidth());
        conf.getDisplay().getResolution().setHeight(value.getDisplayHeight());
        conf.getDisplay().setScreenSize(factory.createDisplayScreenSize());
        conf.getDisplay().getScreenSize().setUnit(value.getDisplaySizeUnit());
        conf.getDisplay().getScreenSize().setValue(value.getDisplaySize());
        conf.getDisplay().setSkin(factory.createDisplaySkin());
        if (value.getSkinPath() != null && !value.getSkinPath().isEmpty()) {
            conf.getDisplay().getSkin().setName(value.getSkinName());
            conf.getDisplay().getSkin().setPath(value.getSkinPath());
        }
        conf.getDisplay().getSkin().setShape(value.getSkinShape().toString());
        conf.getRam().setSize(factory.createRamSize());
        conf.getRam().getSize().setUnit(value.getRamSizeUnit());
        conf.getRam().getSize().setValue(value.getRamSize());
        conf.getCpu().setCount(value.getCpuCount());
        if (value.getAdditionalDevices().size() > 0) {
            conf.setAdditionalDevices(factory.createAdditionalDevices());
            conf.getAdditionalDevices().getDevice().clear();
            for (SubDevice device : value.getAdditionalDevices()) {
                Device d = new Device();
                d.setName(device.getName());
                for (SubDeviceItem item : device.getItems()) {
                    DeviceItem i = new DeviceItem();
                    if (item.getValues() == null || item.getValues().size() > 0) {
                        // empty if block
                    }
                    i.setId(item.getId());
                    i.setSupport(item.isSupport());
                    if (item.getName() != null && !item.getName().isEmpty()) {
                        i.setName(item.getName());
                    }
                    d.getDeviceItem().add(i);
                }
                for (SubDeviceValue subDeviceValue : device.getValues()) {
                    DeviceValue deviceValue = new DeviceValue();
                    deviceValue.setName(subDeviceValue.getName());
                    deviceValue.setValue(subDeviceValue.getValue());
                    deviceValue.setUnit(subDeviceValue.getUnit());
                    d.getDeviceValue().add(deviceValue);
                }
                conf.getAdditionalDevices().getDevice().add(d);
            }
        }
        return conf;
    }

    void settingDeviceTemplateValue() {
        this.settingDeviceTemplateValue(this.value);
    }

    void settingDeviceTemplateValue(DeviceTemplateValue value) {
        if (this.conf == null) {
            return;
        }
        if (value == null) {
            return;
        }
        if (this.conf.getBaseInformation() != null) {
            value.setName(this.conf.getBaseInformation().getName());
            String type = this.conf.getBaseInformation().getType();
            value.setType(type);
            value.setProfile(this.conf.getBaseInformation().getProfile());
            value.setExtenstion(this.conf.getBaseInformation().getExtension());
            int p = this.conf.getBaseInformation().getPriority();
            DeviceTemplatePriority priority = DeviceTemplatePriority.findPriority(p);
            if (priority == null) {
                priority = DeviceTemplatePriority.CUSTOM;
            }
            value.setPriority(priority);
            value.setVersion(this.conf.getBaseInformation().getVersion());
            value.setManufacturer(this.conf.getBaseInformation().getManufacturer());
        }
        if (this.conf.getDisplay() != null) {
            if (this.conf.getDisplay().getResolution() != null) {
                value.setDisplayWidth(this.conf.getDisplay().getResolution().getWidth());
                value.setDisplayHeight(this.conf.getDisplay().getResolution().getHeight());
            }
            if (this.conf.getDisplay().getScreenSize() != null) {
                value.setDisplaySizeUnit(this.conf.getDisplay().getScreenSize().getUnit());
                value.setDisplaySize(this.conf.getDisplay().getScreenSize().getValue());
            } else {
                value.setDisplaySize(0.0);
            }
            int width = value.getDisplayWidth();
            int height = value.getDisplayHeight();
            value.setResolution(RESOLUTION.findAndCreateResolution(width, height));
            if (this.conf.getDisplay().getSkin() != null) {
                String skinName = this.conf.getDisplay().getSkin().getName();
                String skinPath = this.conf.getDisplay().getSkin().getPath();
                String shape = this.conf.getDisplay().getSkin().getShape();
                SKIN_SHAPE skinShape = null;
                if (shape != null && !shape.isEmpty()) {
                    skinShape = SKIN_SHAPE.find(shape);
                }
                Skin skin = null;
                if (skinPath != null && !skinPath.isEmpty()) {
                    try {
                        skin = new Skin(new File(skinPath));
                    }
                    catch (IOException e) {
                        skin = null;
                        EMLogger.getLogger().warning("Failed to create skin." + e.getMessage());
                    }
                }
                if (skin != null) {
                    value.setSkin(skin);
                } else {
                    value.setSkinPath(skinPath);
                    value.setSkinName(skinName);
                }
                value.setSkinShape(skinShape);
            }
        }
        if (this.conf.getCpu() != null) {
            value.setCpuCount(this.conf.getCpu().getCount());
        }
        if (this.conf.getRam() != null) {
            value.setRamSizeUnit(this.conf.getRam().getSize().getUnit());
            value.setRamSize(this.conf.getRam().getSize().getValue());
        }
        if (this.conf.getAdditionalDevices() != null) {
            ArrayList<SubDevice> additionalDevices = new ArrayList<SubDevice>();
            for (Device device : this.conf.getAdditionalDevices().getDevice()) {
                SubDevice aDevice = new SubDevice();
                aDevice.setName(device.getName());
                for (DeviceItem deviceItem : device.getDeviceItem()) {
                    SubDeviceItem item = this.makeSubDeviceItem(deviceItem);
                    if (item == null) continue;
                    aDevice.addSubDeviceItem(item);
                }
                for (DeviceValue deviceValue : device.getDeviceValue()) {
                    SubDeviceValue subDeviceValue = this.makeSubDeviceValue(deviceValue);
                    if (subDeviceValue == null) continue;
                    aDevice.addSubDeviceValue(subDeviceValue);
                }
                additionalDevices.add(aDevice);
            }
            value.setAdditionalDevices(additionalDevices);
        }
    }

    private SubDeviceItem makeSubDeviceItem(DeviceItem deviceItem) {
        SubDeviceItem item = new SubDeviceItem(deviceItem.getId());
        item.setName(deviceItem.getName());
        item.setSupport(deviceItem.isSupport());
        for (DeviceItemValue value : deviceItem.getDeviceItemValue()) {
            item.addDeviceItemVale(value.getName(), value.getUnit(), value.getValue());
        }
        return item;
    }

    private SubDeviceValue makeSubDeviceValue(DeviceValue deviceValue) {
        SubDeviceValue subDeviceValue = new SubDeviceValue(deviceValue.getName(), deviceValue.getUnit(), deviceValue.getValue());
        return subDeviceValue;
    }

    @Override
    public int compareTo(DeviceTemplate target) {
        if (this.equals(target)) {
            return 0;
        }
        if (this.getValue().isStandard()) {
            if (!target.getValue().isStandard()) {
                return -1;
            }
        } else if (target.getValue().isStandard()) {
            return 1;
        }
        return this.getValue().getPriority().compareTo(target.getValue().getPriority());
    }
}

