/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;
import org.tizen.emulator.manager.vms.type.SKIN_TYPE;

public class SkinList {
    private static List<Skin> commonSkinList = new ArrayList<Skin>();

    public static List<Skin> getCommonSkinList() {
        return commonSkinList;
    }

    public static List<Skin> loadSkins(String skinsPath, SKIN_SHAPE shape) {
        File skinsDir = new File(skinsPath);
        ArrayList<Skin> skinList = new ArrayList<Skin>();
        if (!skinsDir.exists()) {
            EMLogger.getLogger().warning("This skin directory does not exist: " + skinsPath);
            return skinList;
        }
        File[] fileList = skinsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        if (fileList == null) {
            return skinList;
        }
        for (File skin : fileList) {
            Skin s = null;
            try {
                s = new Skin(skin);
            }
            catch (IOException e) {
                EMLogger.getLogger().warning("Failed adding Skin.." + StringResources.NEW_LINE + "Skin Path: " + skin.getAbsolutePath() + StringResources.NEW_LINE + "Error: " + e.getMessage());
                continue;
            }
            if (shape == SKIN_SHAPE.NONE) {
                skinList.add(s);
                continue;
            }
            if (!s.getSkinShapeList().hasShape(shape)) continue;
            skinList.add(s);
        }
        return skinList;
    }

    public static Skin findSkinByPath(String path, List<Skin> list) {
        if (list != null) {
            for (Skin skin : list) {
                if (!skin.getPath().equals(path)) continue;
                return skin;
            }
        }
        return null;
    }

    public static Skin findSkinByName(String name, List<Skin> list) {
        if (list != null) {
            for (Skin skin : list) {
                if (!skin.getName().equals(name)) continue;
                return skin;
            }
        }
        return null;
    }

    public static SortedSet<Skin> findSkinList(RESOLUTION resolution, List<Skin> list) {
        TreeSet<Skin> returnSkins = new TreeSet<Skin>();
        if (list == null || list.isEmpty()) {
            return returnSkins;
        }
        for (Skin skin : list) {
            if (skin.getType() == SKIN_TYPE.GENERAL) {
                returnSkins.add(skin);
                continue;
            }
            if (!skin.getResolution().equals(resolution)) continue;
            returnSkins.add(skin);
        }
        return returnSkins;
    }

    public static SortedSet<Skin> findSkinList(RESOLUTION resolution, SKIN_SHAPE skinShape, List<Skin> list) {
        TreeSet<Skin> returnSkins = new TreeSet<Skin>();
        if (list == null || list.isEmpty()) {
            return returnSkins;
        }
        for (Skin skin : list) {
            if (skin.getType() != SKIN_TYPE.GENERAL && !skin.getResolution().equals(resolution) || skinShape != SKIN_SHAPE.NONE && !skin.getSkinShapeList().hasShape(skinShape)) continue;
            returnSkins.add(skin);
        }
        return returnSkins;
    }

    public static SortedSet<Skin> findGeneralSkinList(List<Skin> list) {
        TreeSet<Skin> returnSkins = new TreeSet<Skin>();
        if (list == null || list.isEmpty()) {
            return returnSkins;
        }
        for (Skin skin : list) {
            if (skin.getType() != SKIN_TYPE.GENERAL) continue;
            returnSkins.add(skin);
        }
        return returnSkins;
    }

    static {
        String commonPath = FilePathResources.getPlatformCommonPath();
        File commonDir = new File(commonPath);
        if (commonDir.exists()) {
            for (File profile : commonDir.listFiles()) {
                if (!profile.isDirectory()) continue;
                commonSkinList.addAll(SkinList.loadSkins(profile.getAbsolutePath() + FilePathResources.getPlatformSkinsSuffix(), SKIN_SHAPE.NONE));
            }
        }
    }
}

