/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import org.tizen.emulator.manager.network.NetworkProxy;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class NetProxyOption
extends Option {
    public static final String PROXY_COMMENT = "# network_proxy : use host's proxy configuration\n# (only if VM's proxy option is set as using host proxy)";

    public static String getHostProxyCmd(VMProperty property) throws VMWorkerException {
        String proxyMode = property.getPropertyValue().getAdvancedSubOptionValue("proxy", "proxyMode");
        if (proxyMode.equals("auto")) {
            return NetworkProxy.getHostProxy();
        }
        return "";
    }

    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMWorkerException {
        String proxyConfig;
        String proxyMode = property.getPropertyValue().getAdvancedSubOptionValue("proxy", "proxyMode");
        String comment = null;
        if ("auto".equals(proxyMode)) {
            comment = PROXY_COMMENT;
            proxyConfig = "";
        } else {
            proxyConfig = "manual".equals(proxyMode) ? NetworkProxy.getManualProxy(property) : null;
        }
        if (proxyConfig != null) {
            config.addVariable(OPTION_KEY.VAR_NETWORK_PROXY, "\"" + proxyConfig + "\"", comment);
            config.addKernelOption(NetProxyOption.varForm(OPTION_KEY.VAR_NETWORK_PROXY));
        }
    }
}

