/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.concurrent.overseer.CheckGPU;
import org.tizen.emulator.manager.concurrent.overseer.CheckVT;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ToggleButtonController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.property.CPUVirtualizationProperty;
import org.tizen.emulator.manager.vms.property.GLAccelerationProperty;

public class HWSupportItemController
extends ToggleButtonController {
    private static String CPUDisableToolTipText = Messages.getString("CPUSupportSubViewItem.CPUToolTip.0") + StringResources.NEW_LINE + Messages.getString("CPUSupportSubViewItem.CPUToolTip.1");
    private static String GPUToolTipText = Messages.getString("GPUSupportSubViewItem.GPUToolTip.0") + StringResources.NEW_LINE + Messages.getString("GPUSupportSubViewItem.GPUToolTip.1");
    private static String GPUDisableToolTipText = Messages.getString("GPUSupportSubViewItem.GPUToolTip.2") + StringResources.NEW_LINE + Messages.getString("GPUSupportSubViewItem.GPUToolTip.3");
    public final String GALLIUM_WARNING_MSG = Messages.getString("GPUSupportSubViewItem.GraphicCardError.0") + StringResources.NEW_LINE + Messages.getString("GPUSupportSubViewItem.GraphicCardError.1") + StringResources.NEW_LINE + Messages.getString("GPUSupportSubViewItem.GraphicCardError.2") + StringResources.NEW_LINE + Messages.getString("GPUSupportSubViewItem.GraphicCardError.3") + StringResources.NEW_LINE + Messages.getString("GPUSupportSubViewItem.GraphicCardError.4");
    private boolean isCPU = true;

    public HWSupportItemController(Item item) {
        super(item);
        this.isCPU = item.getName().equals("cpu");
    }

    @Override
    protected void onChangedValue(Event event) {
        super.onChangedValue(event);
        this.checkValid();
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        super.setIntializeValue(value);
        if (this.getMode() == MODE.CREATE) {
            if (this.isCPU) {
                this.button.setSelected(CPUVirtualizationProperty.getDefault());
            } else {
                this.button.setSelected(GLAccelerationProperty.getDefault());
            }
        }
        this.checkValid();
    }

    @Override
    public void checkValid() {
        STATE newState = STATE.OK;
        String message = "";
        if (this.isCPU) {
            if (!CheckVT.isVTSupported() && this.button.isSelected()) {
                newState = STATE.ERROR;
                message = CPUDisableToolTipText;
            }
        } else if (this.button.isSelected()) {
            if (!CheckGPU.isGPUSupported()) {
                newState = STATE.ERROR;
                message = GPUDisableToolTipText;
            } else if (CheckGPU.isGallium()) {
                newState = STATE.WARNING;
                message = this.GALLIUM_WARNING_MSG;
            }
        }
        this.setItemState(newState, message);
    }
}

