/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.controller;

import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.RadioViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.DiskImageFormat;

public class ImageFormatViewController
extends ViewItemController {
    private RadioViewItem viewItem;
    private DiskImageFormat imageFormat;

    public ImageFormatViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new RadioViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        if (item instanceof RadioViewItem) {
            this.viewItem = (RadioViewItem)item;
        }
        if (this.viewItem == null) {
            return;
        }
        this.viewItem.setTitle(this.getTitle());
        this.viewItem.setSpacing(20.0);
        this.addListener();
    }

    private void addListener() {
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                ImageFormatViewController.this.imageFormat = (DiskImageFormat)((Object)event.data);
                ItemEvent iEvent = new ItemEvent(ImageFormatViewController.this.getName());
                iEvent.data = ImageFormatViewController.this.imageFormat;
                ViewItemController.sendChangeEvent(iEvent);
            }
        });
    }

    private void addButtons(DiskImageFormat format) {
        this.viewItem.addButton(format.getName(), (Object)format);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        if (this.mode == MODE.CREATE) {
            this.addButtons(DiskImageFormat.QCOW2);
            this.addButtons(DiskImageFormat.RAW);
            this.viewItem.setSelect(0);
        } else {
            this.imageFormat = (DiskImageFormat)((Object)value.getObjectValue(this.getName()));
            this.viewItem.setAsLabel(this.imageFormat.toString());
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue(this.getName(), (Object)this.imageFormat);
    }

    @Override
    public void checkValid() {
    }
}

