/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.item;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;

public class BasePlatformViewItem
extends ComboViewItem {
    private static final String PROFILE_LABEL = "Profile : ";
    private static final String ARCH_LABEL = "Arch : ";
    private static final String SKIN_SHAPE_LABEL = "Skin shape : ";
    private final Label profileLabel;
    private final Label archLabel;
    private final Label skinShapeLabel;

    public BasePlatformViewItem() {
        GridPane pane = (GridPane)this.getContent();
        pane.setVgap(8.0);
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER_LEFT);
        box.setSpacing(8.0);
        box.setPadding(new Insets(0.0));
        pane.add((Node)box, 1, 1);
        this.profileLabel = new Label(PROFILE_LABEL);
        this.archLabel = new Label(ARCH_LABEL);
        this.skinShapeLabel = new Label(SKIN_SHAPE_LABEL);
        box.getChildren().addAll((Object[])new Node[]{this.profileLabel, this.archLabel, this.skinShapeLabel});
    }

    public void setProfile(String profile) {
        this.profileLabel.setText(PROFILE_LABEL + profile);
    }

    public void setArch(String arch) {
        this.archLabel.setText(ARCH_LABEL + arch);
    }

    public void setSkinShape(String skinShape) {
        this.skinShapeLabel.setText(SKIN_SHAPE_LABEL + skinShape);
    }
}

