/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console.util;

import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.CommandList;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;

public class OutputUtil {
    private static int columns = 0;

    public static void print(String message) {
        System.out.println(message);
    }

    public static void printError(String message) {
        OutputUtil.printError(message, "");
    }

    public static void printError(String message, String additionalMsg) {
        System.out.println("Error: " + message);
        if (additionalMsg != null && !additionalMsg.isEmpty()) {
            System.out.println(additionalMsg);
        }
    }

    public static void printErrorAndHelp(Command command, String message) {
        if (message != null) {
            System.out.println("Error: " + message);
        }
        if (command == null) {
            OutputUtil.printGlobalHelp();
        } else {
            OutputUtil.printCommandHelp(command);
        }
    }

    public static void printGlobalHelp() {
        System.out.println(StringResources.NEW_LINE + "Usage: em-cli [global options] <COMMAND> [command options]");
        System.out.println("");
        System.out.println("Global options");
        for (Option c : CommandList.getGlobalCommand().getOptionList()) {
            OutputUtil.printOptionDescription(c.getUsage(), c.getDescription());
        }
        System.out.println(StringResources.NEW_LINE + "Commands");
        for (Command a : CommandList.getCommandList()) {
            OutputUtil.printCommandDescription(a.getCommand(), a.getShortDescription());
        }
    }

    public static void printCommandHelp(Command action) {
        String mandatoryOptions = "";
        int count = 0;
        for (Option c : action.getOptionList()) {
            if (c.isMandatory()) {
                mandatoryOptions = mandatoryOptions + " " + c.getShortUsage();
                continue;
            }
            ++count;
        }
        String usage = "Usage: em-cli " + action.getCommand() + mandatoryOptions;
        if (count > 0) {
            usage = usage + " [options]";
        }
        System.out.println(usage);
        System.out.println("");
        System.out.println("Command description");
        OutputUtil.printWithLine(action.getDescription());
        System.out.println();
        System.out.println("Options");
        for (Option c : action.getOptionList()) {
            String key = c.getUsage();
            String description = c.getDescription();
            if (!c.getDefaultValue().isEmpty()) {
                description = description + " [default: " + c.getDefaultValue() + "]";
            }
            OutputUtil.printOptionDescription(key, description);
        }
        System.out.println();
        System.out.println("Examples");
        OutputUtil.printUsage(action.getUsage());
    }

    private static void printWithLine(String value) {
        String[] usages;
        assert (value != null);
        for (String usage : usages = value.split(StringResources.NEW_LINE)) {
            System.out.println("  " + usage);
        }
    }

    private static void printUsage(String value) {
        assert (value != null);
        String[] usages = value.split(StringResources.NEW_LINE);
        boolean odd = false;
        for (String usage : usages) {
            if (!odd) {
                System.out.println("  " + usage);
                odd = true;
                continue;
            }
            System.out.println("    em-cli " + usage);
            odd = false;
        }
    }

    public static void printKeyandValue(String key, String value) {
        OutputUtil.printCommandDescription(key, ": " + value);
    }

    private static void printOptionDescription(String value, String description) {
        String[] str;
        String key;
        assert (value != null);
        assert (description != null);
        if (columns == 0) {
            String env = System.getenv("COLUMNS");
            if (env != null) {
                columns = Integer.valueOf(env);
            }
            if (columns <= 0) {
                columns = 80;
            }
        }
        if ((key = value).length() > 26) {
            System.out.println("  " + key);
            key = "";
        }
        for (String desc : str = description.split(StringResources.NEW_LINE)) {
            int length = desc.length();
            int start = 0;
            int index = columns - 26;
            index = OSUtil.isWin() ? (index -= 4) : (index -= 3);
            while (length > index) {
                System.out.print(String.format("  %-26s %s", key, desc.substring(start, start + index)));
                System.out.println();
                start += index;
                length -= index;
                key = "";
            }
            System.out.print(String.format("  %-26s %s", key, desc.substring(start, start + length)));
            System.out.println();
            key = "";
        }
    }

    private static void printCommandDescription(String value, String description) {
        String[] str;
        String key;
        assert (value != null);
        assert (description != null);
        if (columns == 0) {
            String env = System.getenv("COLUMNS");
            if (env != null) {
                columns = Integer.valueOf(env);
            }
            if (columns <= 0) {
                columns = 80;
            }
        }
        if ((key = value).length() > 17) {
            System.out.println("  " + key);
            key = "";
        }
        for (String desc : str = description.split(StringResources.NEW_LINE)) {
            int length = desc.length();
            int start = 0;
            int index = columns - 17;
            index = OSUtil.isWin() ? (index -= 4) : (index -= 3);
            while (length > index) {
                System.out.print(String.format("  %-17s %s", key, desc.substring(start, start + index)));
                System.out.println();
                start += index;
                length -= index;
                key = "";
            }
            System.out.print(String.format("  %-17s %s", key, desc.substring(start, start + length)));
            System.out.println();
            key = "";
        }
    }
}

