/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent.overseer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import org.tizen.emulator.manager.concurrent.overseer.Job;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;

public class CheckSDCard
extends Job {
    CheckSDCard() {
    }

    public static boolean isSDCardChecked() {
        CheckSDCard.getInstance(CheckSDCard.class);
        return true;
    }

    @Override
    public void work() {
        this.copyDirectory(new File(FilePathResources.getToolEmulatorSDCardPath()), new File(FilePathResources.getBaseSDCardPath()));
    }

    private void copyDirectory(File sourcePath, File targetPath) {
        if (!targetPath.exists()) {
            targetPath.mkdir();
        }
        for (File source : sourcePath.listFiles()) {
            Path target = Paths.get(targetPath.getAbsolutePath(), source.getName());
            if (source.isDirectory()) {
                this.copyDirectory(source, target.toFile());
                continue;
            }
            if (Files.exists(target, new LinkOption[0])) continue;
            try {
                EMLogger.getLogger().info("Copy SDCard image from " + source.toString() + " to " + target.toString());
                Files.copy(source.toPath(), target, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                EMLogger.getLogger().log(Level.SEVERE, "Failed to create SDCard image !!!" + StringResources.NEW_LINE + e.getMessage());
            }
        }
    }
}

