#!/bin/bash -ex

TIZEN_KVM_SCRIPT="/etc/init.d/tizen-kvm-multi"
if [ -f ${TIZEN_KVM_SCRIPT} ]
then
    echo "tizen-kvm-multi does exist. tizen-kvm does not need to be uninstalled."
    exit 0;
fi

TMP_FILE=remove_tizen-kvm.sh
echo "#!/bin/bash -ex" >> ${TMP_FILE}
if [ "ubuntu" = "${OS_NAME}" ] ; then
    echo "update-rc.d -f tizen-kvm remove" >> ${TMP_FILE}
fi
echo "rm -f /etc/init.d/tizen-kvm" >> ${TMP_FILE}
echo "rm -f /lib/udev/rules.d/45-tizen-kvm.rules" >> ${TMP_FILE}

chmod +x ${TMP_FILE}

if [ "${TSUDO}" != "" ] # since installer v2.27
then
    TSUDO_MSG="Enter your password to remove /etc/init.d/tizen-kvm."
    TMP_PATH="`pwd`/${TMP_FILE}"
    "$TSUDO" -m "${TSUDO_MSG}" sh "${TMP_PATH}"
else
    GKSUDO=`which gksudo`
    if [ "${GKSUDO}" = "" ]
    then
        echo "there is no gksudo."
        sudo ./${TMP_FILE}
    else
        gksudo ./${TMP_FILE}
    fi
fi

rm ${TMP_FILE}
