=begin 
  
 OBS2/controller.rb 
 
Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved. 
 
Contact: 
Taejun Ha <taejun.ha@samsung.com> 
Jiil Hyoun <jiil.hyoun@samsung.com> 
Donghyuk Yang <donghyuk.yang@samsung.com> 
DongHee Yang <donghee.yang@samsung.com> 
 
Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 
 
http://www.apache.org/licenses/LICENSE-2.0 
 
Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
 
Contributors: 
- S-Core Co., Ltd 
=end 

require 'fileutils'

class RootstrapController
	@@installed = false
	@@zypper_initiated = false
    attr_accessor :type

	def initialize
		@rootstrap = nil
	    @arch=""
	    @arch_rpm=""
	    @obs_http_proxy=""
		@is_remote=true
        @type = File.basename(File.dirname(__FILE__))
		path =  (__FILE__.start_with? ".")? FileUtils.pwd + __FILE__[1..-1] : __FILE__
		@dist = (File.exist? File.dirname(path) + "/dist.conf")? "-D " + File.dirname(path) + "/dist.conf" : ""
		# Let's assume OBS is installed
	end


	# create new rootstrap
	def create_new_rootstrap( rootstrap )
		@rootstrap = rootstrap

		arch = @rootstrap.arch
		if arch == "arm" then
			@arch = "armv7l"
			@arch_rpm = "armv7l"
		else
			@arch = "i586"
			@arch_rpm = "i586"
		end

		# extract base image into rootstrap path
		path = @rootstrap.path
		if not system("sudo rm -rf #{path}") then return false end
		system "mkdir -p #{path}"
		# Do not need to set root user permission to rootstrap path
		# system("sudo chown root #{path}")
		
		@rootstrap.url_list.each do |l|
			if l.start_with? "." or l.start_with? "/" or l.start_with? "file:/" or l.start_with? "dir:/" then
				@is_remote = false
				break
			end
		end
		@dist = "" if @is_remote

        if @rootstrap.http_proxy.nil? then
            @obs_http_proxy=nil
        else
            @obs_http_proxy=@rootstrap.http_proxy
        end
        # extract base image
        # system "fakeroot tar -xpf #{$WORKING_DIR}/baseimage_#{arch}.tar.gz -C #{path}"

	end


	# install packages
	def install_packages
		# generate base.spec
		system "rm -rf dummy"
		system "mkdir -p dummy/packaging"
		File.open( "dummy/packaging/dummy.spec", "w") do |w|
			w.puts "Name:       dummy"
			w.puts "Summary:    Tempory project for building base image"
			w.puts "Version:    1.0.0"
			w.puts "Release:    1"
			w.puts "Group:      Utility"
			w.puts "License:    Apache License, Version 2.0"
			w.puts "Source0:    %{name}-%{version}.tar.gz"
			w.puts "BuildRequires: zypper"
			w.puts "%description"
			w.puts "Application utility library"
			w.puts ""
			w.puts "%prep"
			w.puts "%setup -q"
			w.puts ""
			w.puts "%build"
			w.puts ""
			w.puts "%install"
			w.puts ""
			w.puts "%files"
			w.puts ""
			w.puts "%description"
			w.puts "Application utility library"
		end

		FileUtils.cd "dummy"
		if not system( "git init" ) then return false end
		system( "git add *" )
		system( "git commit -m init")
		# build
		if not @obs_http_proxy.nil? then
			$log.info "export http_proxy=#{@obs_http_proxy}; gbs build -A #{@arch_rpm} --clean --include-all --skip-conf-repos --buildroot=#{@rootstrap.path} -R #{@rootstrap.url_list.join(" -R ")} #{@dist}"
			result = system "export http_proxy=#{@obs_http_proxy}; gbs build -A #{@arch_rpm} --clean --include-all --skip-conf-repos --buildroot=#{@rootstrap.path} -R #{@rootstrap.url_list.join(" -R ")} #{@dist}"
		else
			$log.info "gbs build -A #{@arch} --clean --include-all --skip-conf-repos --buildroot=#{@rootstrap.path} -R #{@rootstrap.url_list.join(" -R ")} #{@dist}"
			result = system "gbs build -A #{@arch} --clean --include-all --skip-conf-repos --buildroot=#{@rootstrap.path} -R #{@rootstrap.url_list.join(" -R ")} #{@dist}"
		end
		FileUtils.cd ".."
		if not result then return false end	

		# install packages
		pkg_list = @rootstrap.base_pkg_list
		pkg_list.each do |pkg|
			install_using_zypper pkg
		end

		link_directory

		return true
	end


	# remove packages
	def remove_packages
		@rootstrap.remove_pkg_list.each do |pkg|
			command("rpm -e --nodeps #{pkg.name}")
		end
	end


    def reload ( rootstrap )
        @rootstrap = rootstrap
    end

	# get all package list installed
	def get_all_installed_packages
		result = []
		command_and_return("rpm -qa --queryformat=\\\"%{NAME}\\n\\\"").each_line do |line|
			result.push line.strip
        end

		return result
	end


	# get all file list in package
	def get_all_package_files(pkg_name)
		result = []
		command_and_return("rpm -ql #{pkg_name}").each_line do |line|
			file_path = line.strip!
			result.push file_path
		end

        return result
	end


	# get all dependent packages
	def get_all_dependent_packages(pkg_name)
		result = []
        command_and_return("zypper info --requires #{pkg_name}").each_line do |line|
            if not line.include? "(" and
				(line.include? "==" or line.include? ">=" or line.include? "<=") then
                #remove "Depends: (xxx) , "
                package = line.split("==")[0].strip
				result.push package
			end
        end

        return result
	end


	# get include search paths of package
	def get_include_search_paths_using_pkgconfig(pc_list)
		result = []

		# default search path
        result = ["/usr/include"]

        # get package Include list using pkg-config
		pc_list.each do |x|
			result = result |
				((command_and_return "pkg-config --cflags-only-I #{x}").split.map {|i| i.sub("-I","")})
		end

		# remove dup
		result.uniq!

        return result
	end


    # write self information to file that will save
    def write_info ( file_path )
    end


    # compare saved information file with self
    def same_as? ( file_path )
        return false
    end


	# PRIVATE METHODS/VARIABLES
	private

	# zypper install ...
	def install_using_zypper pkg
		# prepare for installation if first entered
		if not @@zypper_initiated  then
			initiated_zypper_installation(pkg.protocol, pkg.url)
			@@zypper_initiated = true
		end

		# execute zypper command
        case pkg.protocol
        when "rpm" then
			if not @obs_http_proxy.nil? then
				command "export http_proxy=#{@obs_http_proxy}; zypper --non-interactive install #{pkg.name}"
			else
				command "zypper --non-interactive install #{pkg.name}"
			end
		when "cp" then
			system("sudo cp #{pkg.url} #{@rootstrap.path}")
			command "rpm --install ./#{File.basename(pkg.url)}"
			system("sudo rm -rf #{@rootstrap.path}/#{File.basename(pkg.url)}")

		else $log.warn "pkg protocol is unknown #{pkg.protocol}"
		end
	end


	# step for preparation
    def initiated_zypper_installation (protocol, url)
		path = @rootstrap.path + "/local/BUILD-ROOTS/scratch.#{@arch_rpm}.0"
        system("sudo chmod +w #{path}")
        # Set /etc/rpm/platform
        command "echo -n '#{@arch_rpm}-generic-linux' > /etc/rpm/platform"

		# Reset package db information
		# command "rm -rf /var/lib/rpm/__db*"
		# command "rpmdb --rebuilddb"

		# zypper a
#		$log.info "zypper ar http://165.213.148.149:82/TIZEN:/1.0:/Public/standard tizen_public"
#		command "zypper ar http://165.213.148.149:82/TIZEN:/1.0:/Public/standard tizen_public"
#		$log.info "zypper ar http://165.213.148.149:82/TIZEN:/1.0:/Shared/standard tizen_shared"
#		command "zypper ar http://165.213.148.149:82/TIZEN:/1.0:/Shared/standard tizen_shared"
#		$log.info "zypper ar http://165.213.148.149:82/TIZEN:/1.0:/Hidden/standard tizen_hidden"
#		command "zypper ar http://165.213.148.149:82/TIZEN:/1.0:/Hidden/standard tizen_hidden"
#		$log.info "zypper ar http://165.213.148.149:82/SLP:/Bootstrap/standard slp_bootstrap"
#		command "zypper ar http://165.213.148.149:82/SLP:/Bootstrap/standard slp_bootstrap"
#		$log.info "zypper ar http://165.213.148.149:82/SLP:/System/standard slp_system"
#		command "zypper ar http://165.213.148.149:82/SLP:/System/standard slp_system"
        count=0
        @rootstrap.url_list.each do |url|
            command "zypper ar #{url} url#{count}"
            count+=1
        end

		# zypper refesh
		if not @obs_http_proxy.nil? then
			command "export http_proxy=#{@obs_http_proxy}; zypper refresh"
		else
			command "zypper refresh"
		end
	end

	# link /opt/apps -> /opt/usr/apps
	def link_directory
		command "mkdir -p /opt/usr/apps"
		command "ln -s /opt/usr/apps /opt/"
	end			

	# command to target
	def command(cmd)
		path = @rootstrap.path + "/local/BUILD-ROOTS/scratch.#{@arch_rpm}.0"
		$log.info "sudo chroot #{path} sh -c \"#{cmd}\""
		system "sudo chroot #{path} sh -c \"#{cmd}\""
	end


	# return result of command
    def command_and_return(cmd)
		path = @rootstrap.path + "/local/BUILD-ROOTS/scratch.#{@arch_rpm}.0"
		$log.info "sudo chroot #{path} sh -c \"#{cmd}\""
		return `sudo chroot #{path} sh -c \"#{cmd}\"`
    end
end

