=begin
 
 rootstrapmanager.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

class RootstrapManager
    def RootstrapManager.create (name, arch, pkglist, ctrl, url_list, http_proxy, save)
		load File.dirname(__FILE__) + "/controllers/" + ctrl + "/controller.rb"

        ctrl = RootstrapController.new
        saved_rootstrap = get_saved_rootstrap_name(name, arch, pkglist, ctrl)
        $log.info "saved rootstrap exist #{saved_rootstrap.join(" : ")}"

        if saved_rootstrap.empty? 
            rootstrap = Rootstrap.new(name, arch, pkglist, ctrl, url_list, http_proxy)
            rootstrap.generate
            if save then 
                save_rootstrap rootstrap
            end 
        else 
            load_saved_rootstrap saved_rootstrap
            rootstrap = Rootstrap.new(name, arch, pkglist, ctrl, url_list, http_proxy)
            rootstrap.regenerate
        end

        return rootstrap
    end 

    def RootstrapManager.get_saved_rootstrap_name (name, arch, pkglist, ctrl)
        saved_rootstrap = []

        local_save = get_local_save(name, arch, pkglist, ctrl)
        if not local_save.empty? then 
            saved_rootstrap = ["local", local_save]
        else
            remote_save = get_remote_save(name, arch, pkglist, ctrl)
            if not remote_save.empty? then 
                saved_rootstrap = ["remote", remote_save]
            end
        end 

        return saved_rootstrap
    end 

    def RootstrapManager.get_local_save (name, arch, pkglist, ctrl) 
        #get local_save_path from rogen.cfg
        local_save_path = "#{get_value_from_file File.dirname(__FILE__) + "/rogen.cfg", "local_save_path"}".sub(/^~/,$HOME)
        if not local_save_path.empty? then 
            FileUtils.mkdir_p local_save_path
            #get contents of local_save_path 
            local_save_list = `ls #{local_save_path}`.split

            #check _ctrl, and _pkglist and .zip 
            (local_save_list.select {|x| x =~ /#{name}-#{arch}-.*_ctrl$/}).each do |l|
                if local_save_list.include? l.sub(/_ctrl$/,"_pkglist") and local_save_list.include? l.sub(/_ctrl$/,".zip") then 
                    save_name = l.sub(/_ctrl$/,"")

                    #check ctrl
                    if ctrl.same_as? local_save_path + "/" + save_name + "_ctrl" then 

                        #check pkglist
                        local_pkglist = Package.load_package_list_from_file local_save_path + "/" + save_name + "_pkglist", ""

                        if local_pkglist == pkglist then 
                            return save_name + ".zip"
                        end 
                    end 
                end 
            end 
        else 
            $log.warn "local save path is not set in rogen.cfg"
        end 
        return ""
    end

    def RootstrapManager.get_remote_save (name, arch, pkglist, ctrl) 
        #get remote_save_path from rogen.cfg
        remote_save_path = "#{get_value_from_file File.dirname(__FILE__) +"/rogen.cfg", "remote_save_path"}"
        if not remote_save_path.empty? then 
            #get contents of local_save_path 
            r = remote_save_path.split(":")
            remote_save_list = `ssh #{r[0]} \"ls #{r[1]}\"`.split

            #check _ctrl, and _pkglist and .zip 
            (remote_save_list.select {|x| x =~ /#{name}-#{arch}-.*_ctrl$/}).each do |l|
                save_name = l.sub(/_ctrl$/,"")
                if remote_save_list.include? save_name + "_pkglist" and remote_save_list.include? save_name + ".zip"  then 

                    #check ctrl
                    system "scp #{remote_save_path}/#{save_name}_ctrl ."
                    if ctrl.same_as? "./#{save_name}_ctrl" then 
                        FileUtils.rm save_name + "_ctrl"

                        #check pkglist
                        system "scp #{remote_save_path}/#{save_name}_pkglist ."
                        remote_pkglist = Package.load_package_list_from_file save_name + "_pkglist", ""
                        FileUtils.rm save_name + "_pkglist"
                        
                        if remote_pkglist == pkglist then 
                            return save_name + ".zip"
                        end
                    else
                        FileUtils.rm save_name + "_ctrl"
                    end 
                end 
            end 
        else
            $log.warn "remote save path is not set in rogen.cfg"
        end 
        return ""
    end

    def RootstrapManager.load_saved_rootstrap (saved_rootstrap)
        case saved_rootstrap[0]
        when "local" then 
            local_save_path = "#{get_value_from_file File.dirname(__FILE__) + "/rogen.cfg", "local_save_path"}".sub(/^~/,$HOME)
            $log.info "download from #{local_save_path}/#{saved_rootstrap[1]}"
            $log.info "unzip -q #{local_save_path}/#{saved_rootstrap[1]} -d #{$WORKING_DIR}"
            system "unzip -q #{local_save_path}/#{saved_rootstrap[1]} -d #{$WORKING_DIR}"
        when "remote" then 
            remote_save_path = "#{get_value_from_file File.dirname(__FILE__) + "/rogen.cfg", "remote_save_path"}".split(":")
            #download rootstrap file from remote server
            $log.info "download from #{remote_save_path.join(":")}/#{saved_rootstrap[1]}"
            system "scp #{remote_save_path.join(":")}/#{saved_rootstrap[1]} ." 
            system "unzip -q #{saved_rootstrap[1]} -d #{$WORKING_DIR}"
        else
            raise RuntimeError, "internal error from RootstrapManager.load_saved_rootstrap"
        end
    end 

    def RootstrapManager.save_rootstrap (rootstrap)
        #save local save path
        local_save_path = "#{get_value_from_file File.dirname(__FILE__) + "/rogen.cfg", "local_save_path"}".sub(/^~/,$HOME)
        remote_save_path = "#{get_value_from_file File.dirname(__FILE__) + "/rogen.cfg", "remote_save_path"}"

        if local_save_path.empty? and remote_save_path.empty? then return "" end 
        local_save_path = "." if local_save_path.empty? 

        $log.info "save rootstrap to local #{local_save_path}"
        save_rootstrap_name = "#{rootstrap.name}-#{rootstrap.arch}-#{Time.now.usec}"

        #save rootstrap
        system "zip -q -r -y #{local_save_path}/#{save_rootstrap_name}.zip #{rootstrap.name}"

        #save pkglist
        File.open("#{save_rootstrap_name}_pkglist", "w") do |f|
            rootstrap.base_pkg_list.each do |l|
                f.puts l.name.strip + ", " + l.protocol.strip + ", " + l.url.strip
            end 
        end
        FileUtils.cp "#{save_rootstrap_name}_pkglist", "#{local_save_path}"

        #save ctrl
        rootstrap.ctrl.write_info "#{local_save_path}/#{save_rootstrap_name}_ctrl"

        #save remote save path
        if not remote_save_path.empty? then 
            $log.info "save rootstrap to remote #{remote_save_path}"
            system "scp #{local_save_path}/#{save_rootstrap_name}.zip #{remote_save_path}" 
            system "scp #{local_save_path}/#{save_rootstrap_name}_ctrl #{remote_save_path}" 
            system "scp #{local_save_path}/#{save_rootstrap_name}_pkglist #{remote_save_path}" 
        end 
    end 
end 
