=begin
 
 util.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

def make_sourceslist (repository, snapshot)
    #open repository to modify snapshot information
    p = []
    File.open(repository,"r") do |f|
        f.each_line do |line|
            if snapshot.empty? then 
                line.gsub!("@snapshot@","")
            else
                line.gsub!("@snapshot@","/snapshots/" + snapshot)
            end
            p.push line
        end 
    end 

    if p.length > 1 then 
        $log.error "ropository information is too much"
    end
    return p[0]
end

def get_value_from_file (file, key)
    if not File.exist? file then raise RuntimeError, "file #{file} is not exist" end 
    regexp = Regexp.new("^[ \t]*#{key}[ \t]*=",Regexp::EXTENDED|Regexp::IGNORECASE|Regexp::MULTILINE)
    File.open(file) do |f|
        f.each_line do |l|
            if l.strip =~ regexp then 
                return l.sub(regexp,"").strip
            end 
        end
        return ""
    end 
end 

def download_file_from_url (protocol,url)
    case protocol
    when "cp" then 
        if File.exist? url then 
            return url
        end 
    when "scp" then 
        # url = tizen-apt:~/xxx/yyy/zzz.deb
        _url = url.split(':')
        domain = _url[0] # tizen-apt
        location = _url[1] # ~/xxx/yyy/zzz.deb
        file = _url[1].split('/')[-1] # zzz.deb

        # if find file then download it using scp
        if file.empty? then 
            $log.error "cat't find file frome #{url} "
        else
            system "scp #{url} ."
        end 

        if File.exist? file then 
            return file
        end 
    else 
        $log.warn "unknown download protocol #{protocol}"    
    end 
    return ""
end

