/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;

public class Config {
    private String installDirectory;
    private String dataLocation;
    private boolean isAvaliableInstallDirectory = true;
    private boolean isAvaliableDataDirectory = true;
    private Properties prop = new Properties();

    public Config() throws IMFatalException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/res/properties/Config-properties.xml");
            this.prop.loadFromXML(is);
        }
        catch (Exception e) {
            throw new IMFatalException(ErrorController.ErrorCode.CANNOT_FIND_CONFIG_FILE);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new IMFatalException(ErrorController.ErrorCode.CANNOT_ACCESS_FILE);
                }
            }
        }
    }

    public String getInstallDirectory() {
        return this.installDirectory;
    }

    public void setInstallDirectory(String installDirectory) {
        this.installDirectory = installDirectory;
    }

    public String getDataLocation() {
        return this.dataLocation;
    }

    public void setDataLocation(String dataLocation) {
        this.dataLocation = dataLocation;
    }

    public boolean isAvaliableInstallDirectory() {
        return this.isAvaliableInstallDirectory;
    }

    public void setAvaliableInstallDirectory(boolean isAvaliableInstallDirectory) {
        this.isAvaliableInstallDirectory = isAvaliableInstallDirectory;
    }

    public boolean isAvaliableDataDirectory() {
        return this.isAvaliableDataDirectory;
    }

    public void setAvaliableDataDirectory(boolean isAvaliableDataDirectory) {
        this.isAvaliableDataDirectory = isAvaliableDataDirectory;
    }

    public String getConfigValue(ConfigOptions co) {
        return this.prop.getProperty(co.name());
    }

    public static enum ConfigOptions {
        MANAGER_CONFIG_DIRECTORY,
        SDK_DIRECTORY,
        INFO_DIRECTORY,
        DATA_DIRECTORY,
        WINDOWS_DEFAULT_INSTALL_DIRECTORY,
        TARGET_IMAGE_FILE_NAME,
        LOG_FILE_DIRECTORY,
        SDK_INFO_FILE_NAME,
        SDK_INFO_LABEL_INSTALLED_PATH,
        SDK_INFO_LABEL_DATA_PATH,
        SHORTCUT_INFO_FILE_NAME,
        LINUX_DESKTOP_DIR_PATH,
        LINUX_DESKTOP_APPLICATION_PATH,
        LINUX_MENU_DIRECTORY_PATH,
        LINUX_MENU_ICON_FILE_NAME,
        LINUX_MENU_NAME,
        LINUX_MENU_COMMENT,
        LINUX_MENU_VERSION,
        WINDOWS_MAKESHORT_VBS,
        MACOS_MAKESHORT_SH;

    }
}

