/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.custom;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.tizen.installer.exception.ErrorController;
import org.tizen.installer.exception.IMFatalException;
import org.tizen.installer.ui.custom.IMCircularGraph2;
import org.tizen.installer.util.FileUtil;
import org.tizen.installer.util.PathUtil;
import org.tizen.installer.util.PlatformUtil;

public class UIResource {
    ArrayList<Image> loadingImageList = null;
    private HashMap<UIFont, org.eclipse.swt.graphics.Font> fontMap = new HashMap();
    private Properties prop = new Properties();

    public UIResource() throws IMFatalException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/res/properties/ImageResources-properties.xml");
            this.prop.loadFromXML(is);
        }
        catch (Exception e) {
            throw new IMFatalException(ErrorController.ErrorCode.CANNOT_FIND_CONFIG_FILE);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new IMFatalException(ErrorController.ErrorCode.CANNOT_ACCESS_FILE);
                }
            }
        }
    }

    public String getUIResources(Enum<?> option) {
        return this.prop.getProperty(option.name());
    }

    public InputStream getImageStream(UIImages imageName) {
        return this.getClass().getResourceAsStream(this.getUIResources(imageName));
    }

    public ArrayList<Image> getLoadingImage(Display display) {
        if (this.loadingImageList == null) {
            String[] split;
            this.loadingImageList = new ArrayList();
            String loadingImage = this.getUIResources(UIImages.IMAGE_ANIMATION_LOADING);
            for (String string : split = loadingImage.split(",")) {
                this.loadingImageList.add(new Image((Device)display, this.getClass().getResourceAsStream(string)));
            }
        }
        return this.loadingImageList;
    }

    public Rectangle getBounds(UISizes optionName) {
        String uiResources = this.getUIResources(optionName);
        if (uiResources != null) {
            String[] split = uiResources.split(",");
            if (split != null && split.length == 4) {
                int arg0 = Integer.parseInt(split[0].trim());
                int arg1 = Integer.parseInt(split[1].trim());
                int arg2 = Integer.parseInt(split[2].trim());
                int arg3 = Integer.parseInt(split[3].trim());
                return new Rectangle(arg0, arg1, arg2, arg3);
            }
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public org.eclipse.swt.graphics.Font getFontBySize(UIFontSize fontSize, FontType ft, int swtoption) {
        org.eclipse.swt.graphics.Font font = null;
        if (font == null) {
            int size = fontSize.getValue();
            double macFixed = PlatformUtil.isMacOS() ? 0.9 : 1.0;
            size = (int)((double)size * 0.75 * 96.0 * macFixed / (double)Display.getDefault().getDPI().y);
            String fontName = "";
            if (ft != null) {
                if (!PlatformUtil.isWindows()) {
                    try {
                        String name = this.getUIResources(ft);
                        File tempFile = PathUtil.getTempFileFromResource(name, "local_" + System.currentTimeMillis() / 1000L, ".ttf");
                        Font tempFont = Font.createFont(0, tempFile);
                        fontName = tempFont.getFontName();
                        Display.getDefault().loadFont(tempFile.getAbsolutePath());
                        tempFile.deleteOnExit();
                    }
                    catch (Exception name) {
                        // empty catch block
                    }
                    fontName = fontName.split(" ")[0].trim();
                } else {
                    fontName = "Arial";
                }
            } else {
                FontData[] fD = Display.getDefault().getSystemFont().getFontData();
                fontName = fD[0].getName();
            }
            font = new org.eclipse.swt.graphics.Font((Device)Display.getDefault(), new FontData(fontName, size, 0 | swtoption));
        }
        return font;
    }

    public org.eclipse.swt.graphics.Font getFontBySize(UIFontSize fontSize, boolean useCustomFont, int swtoption) {
        return this.getFontBySize(fontSize, null, swtoption);
    }

    public org.eclipse.swt.graphics.Font getFont(UIFont targetFont) {
        org.eclipse.swt.graphics.Font font = this.fontMap.get((Object)targetFont);
        if (font == null) {
            int fontSize = 0;
            if (PlatformUtil.isWindows()) {
                fontSize = targetFont == UIFont.FONT_SIZE_SMALL ? 8 : (targetFont == UIFont.FONT_SIZE_MIDDLE ? 10 : (targetFont == UIFont.FONT_SIZE_LARGE ? 14 : (targetFont == UIFont.FONT_SIZE_PERCENT ? 50 : 8)));
                fontSize = (int)((double)fontSize * 96.0 / (double)Display.getDefault().getDPI().y);
                if (Display.getDefault().getDPI().y > 96) {
                    ++fontSize;
                }
            } else if (PlatformUtil.isMacOS()) {
                fontSize = targetFont == UIFont.FONT_SIZE_SMALL ? 10 : (targetFont == UIFont.FONT_SIZE_MIDDLE ? 12 : (targetFont == UIFont.FONT_SIZE_LARGE ? 18 : (targetFont == UIFont.FONT_SIZE_PERCENT ? 55 : 10)));
                fontSize = (int)((double)fontSize * 72.0 / (double)Display.getDefault().getDPI().y);
                if (Display.getDefault().getDPI().y > 72) {
                    ++fontSize;
                }
            } else {
                fontSize = targetFont == UIFont.FONT_SIZE_SMALL ? 8 : (targetFont == UIFont.FONT_SIZE_MIDDLE ? 10 : (targetFont == UIFont.FONT_SIZE_LARGE ? 15 : (targetFont == UIFont.FONT_SIZE_PERCENT ? 50 : 8)));
                fontSize = (int)((double)fontSize * 96.0 / (double)Display.getDefault().getDPI().y);
                if (Display.getDefault().getDPI().y > 96) {
                    ++fontSize;
                }
            }
            FontData[] fD = Display.getDefault().getSystemFont().getFontData();
            font = new org.eclipse.swt.graphics.Font((Device)Display.getDefault(), new FontData(fD[0].getName(), fontSize, 0));
            this.fontMap.put(targetFont, font);
        }
        return font;
    }

    public Color getColors(UIColors fontColor) {
        Color color = new Color(null, this.getRGBFromString(this.getUIResources(fontColor)));
        return color;
    }

    private RGB getRGBFromString(String value) {
        String[] split = value.split(",");
        int arg0 = Integer.parseInt(split[0].trim());
        int arg1 = Integer.parseInt(split[1].trim());
        int arg2 = Integer.parseInt(split[2].trim());
        RGB returnValue = new RGB(arg0, arg1, arg2);
        return returnValue;
    }

    public void setMouseCurosr(final Control control) {
        final Cursor handCur = new Cursor(null, 21);
        final Cursor arrowCur = new Cursor(null, 0);
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                control.setCursor(handCur);
            }

            public void mouseExit(MouseEvent e) {
                control.setCursor(arrowCur);
            }
        });
    }

    public IMCircularGraph2 handleInstallingForWizardProgress(Composite composite, UIResource uiResource, long defaultValue, int width, int height, int center, int type, Image centerImage, Point centerImageLeftTop) {
        Rectangle point = new Rectangle(0, 0, width, height);
        IMCircularGraph2 imc = new IMCircularGraph2(composite, 0, type, point, center);
        if (type == 0) {
            imc.setValueFont(uiResource.getFontBySize(UIFontSize.FONT_SIZE_40PX, false, 1));
            imc.setMeasureFont(uiResource.getFontBySize(UIFontSize.FONT_SIZE_25PX, false, 1));
        }
        imc.setCenterColor(uiResource.getColors(UIColors.WIZARD_COLOR_WHITE));
        imc.setGraphColor(uiResource.getColors(UIColors.WIZARD_COLOR_PURE_BLUE));
        imc.setBackgroundImage(new Image(null, uiResource.getImageStream(UIImages.WIZARD_IMAGE_INSTALL_IC_BACKGROUND)));
        if (centerImage != null) {
            imc.setCenterImage(centerImage);
            imc.setCenterPoint(centerImageLeftTop);
        } else {
            imc.setCenterImage(new Image(null, uiResource.getImageStream(UIImages.WIZARD_IMAGE_INSTALL_IC_SDK)));
        }
        imc.setVisible(true);
        imc.update(defaultValue);
        return imc;
    }

    public IMCircularGraph2 handleInstallingForWizardProgress(Composite composite, UIResource uiResource, long defaultValue, int width, int height, int center, int type) {
        return this.handleInstallingForWizardProgress(composite, uiResource, defaultValue, width, height, center, type, null, null);
    }

    public void setTextStyle(StyledText styledText, String text, boolean underline) {
        styledText.setText(text);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = text.length();
        styleRange.underline = underline;
        styledText.setStyleRange(styleRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDefaultFont() {
        String resFolder = this.prop.getProperty("WIZARD_FONT_INSTALL");
        if (resFolder != null && !resFolder.isEmpty()) {
            String fromHome;
            File fontDirectory = null;
            if (PlatformUtil.isLinux()) {
                fromHome = PathUtil.getFromHome(".fonts");
                fontDirectory = new File(fromHome);
                if (!fontDirectory.exists()) {
                    fontDirectory.mkdirs();
                }
            } else if (PlatformUtil.isWindows()) {
                String path = System.getenv("WINDIR");
                fontDirectory = new File(path, "Fonts");
            } else if (PlatformUtil.isMacOS() && !(fontDirectory = new File(fromHome = PathUtil.getFromHome("/Library/Fonts/"))).exists()) {
                fontDirectory.mkdirs();
            }
            String[] split = resFolder.split(",");
            String base = split[0].trim();
            boolean isExistFont = false;
            for (int i = 1; i < split.length; ++i) {
                String fileName = split[i].trim();
                String fullName = base + fileName;
                try {
                    File toFile = new File(fontDirectory, fileName);
                    if (!toFile.exists()) {
                        if (PlatformUtil.isWindows()) {
                            File tempFile = new File(fileName);
                            FileUtil.writeFileFromInputStream(PathUtil.getResourceAsStream(fullName), tempFile);
                            isExistFont = true;
                            continue;
                        }
                        FileUtil.writeFileFromInputStream(PathUtil.getResourceAsStream(fullName), toFile);
                        continue;
                    }
                    InputStream resourceAsStream = PathUtil.getResourceAsStream(fullName);
                    if (toFile.length() == (long)resourceAsStream.available() || PlatformUtil.isWindows()) continue;
                    toFile.delete();
                    FileUtil.writeFileFromInputStream(PathUtil.getResourceAsStream(fullName), toFile);
                    continue;
                }
                catch (IOException toFile) {
                    // empty catch block
                }
            }
            if (PlatformUtil.isWindows() && isExistFont) {
                File tempFile = new File("FontReg.exe");
                InputStream is = null;
                try {
                    if (PlatformUtil.CURRENT_PLATFORM == 8) {
                        is = PathUtil.getResourceAsStream("/res/font/bin.x86-32/FontReg.exe");
                        FileUtil.writeFileFromInputStream(is, tempFile);
                    } else {
                        is = PathUtil.getResourceAsStream("/res/font/bin.x86-64/FontReg.exe");
                        FileUtil.writeFileFromInputStream(is, tempFile);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
                String cmd = String.format("FontReg.exe /copy", new Object[0]);
                ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/C", cmd);
                Process proc = null;
                try {
                    proc = pb.start();
                    proc.waitFor();
                    proc.destroy();
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (proc != null) {
                        proc.destroy();
                    }
                }
            }
        }
    }

    public static enum UIImages {
        IMAGE_SDK_ICON,
        IMAGE_ANIMATION_LOADING,
        IMAGE_INFO_DIALOG_BG_TOP,
        WIZARD_IMAGE_INFO_BACKGROUND,
        WIZARD_IMAGE_INFO_ICON,
        WIZARD_IMAGE_QEUSTION_ICON,
        WIZARD_IMAGE_WARNING_ICON,
        WIZARD_IMAGE_TOP_BACKGROUND,
        WIZARD_IMAGE_TOOLTIP_ICON_NORMAL,
        WIZARD_IMAGE_TOOLTIP_ICON_FOCUS,
        WIZARD_IMAGE_TOOLTIP_BG_LEFT,
        WIZARD_IMAGE_TOOLTIP_BG_CENTER,
        WIZARD_IMAGE_TOOLTIP_BG_RIGHT,
        WIZARD_IMAGE_INSTALL_IC_SDK,
        WIZARD_IMAGE_INSTALL_IC_BACKGROUND,
        WIZARD_IMAGE_INSTALL_IC_CANCELED,
        WIZARD_IMAGE_INSTALL_IC_CAUTION,
        WIZARD_IMAGE_PATH_ICON_NOR,
        WIZARD_IMAGE_PATH_ICON_OVER,
        WIZARD_IMAGE_PATH_ICON_SEL,
        WIZARD_IMAGE_CHECK_NORMAL,
        WIZARD_IMAGE_CHECK_SEL;

    }

    public static enum UIColors {
        WIZARD_COLOR_WHITE,
        WIZARD_COLOR_WHITE_SMOKE,
        WIZARD_COLOR_LINE_SPLITTER,
        WIZARD_COLOR_GRAY_B0,
        WIZARD_COLOR_GRAY_80,
        WIZARD_COLOR_GRAY_190,
        WIZARD_COLOR_LICENSE_STROKE,
        WIZARD_COLOR_LICENSE_TEXT,
        WIZARD_COLOR_VERY_DARK_GRAY_33,
        WIZARD_COLOR_PURE_BLUE,
        WIZARD_COLOR_READYPAGE_DIRECTORY_ERROR,
        WIZARD_COLOR_VERY_DARK_GRAY_58,
        WIZARD_COLOR_VERY_DARK_GRAY_72,
        WIZARD_COLOR_READYPAGE_WARN_MESSAGE,
        WIZARD_COLOR_READYPAGE_WARN_LINK,
        WIZARD_COLOR_VERY_LIGHT_GRAY;

    }

    public static enum UIFontSize {
        FONT_SIZE_46PX(46),
        FONT_SIZE_40PX(40),
        FONT_SIZE_34PX(34),
        FONT_SIZE_36PX(36),
        FONT_SIZE_25PX(25),
        FONT_SIZE_20PX(20),
        FONT_SIZE_18PX(18),
        FONT_SIZE_13PX(13),
        FONT_SIZE_11PX(11),
        FONT_SIZE_10PX(10);

        private int value = 0;

        private UIFontSize(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum UIFont {
        FONT_SIZE_LARGE,
        FONT_SIZE_MIDDLE,
        FONT_SIZE_SMALL,
        FONT_SIZE_PERCENT,
        FONT_SIZE_TITLE;

    }

    public static enum FontType {
        OS,
        WIZARD_FONT_TYPE_REGULAR,
        WIZARD_FONT_TYPE_MEDIUM,
        WIZARD_FONT_TYPE_BOLD;

    }

    public static enum UISizes {
        WIZARD_SIZE_BASIC,
        WIZARD_SIZE_TOP,
        WIZARD_SIZE_CENTER,
        WIZARD_SIZE_SPLITTER,
        WIZARD_SIZE_BOTTOM,
        WIZARD_SIZE_TITLE_MAIN,
        WIZARD_SIZE_TITLE_INFO,
        WIZARD_SIZE_INFO_BUTTON,
        WIZARD_SIZE_INFO_TOOLTIP,
        WIZARD_SIZE_BOTTOM_BUTTON,
        WIZARD_SIZE_BOTTOM_BUTTON_MARGIN,
        WIZARD_SIZE_INSTALL_IC_SDK,
        WIZARD_SIZE_INSTALL_IC_CANCEL,
        WIZARD_SIZE_INSTALL_IC_STROKE,
        WIZARD_SIZE_LICENSE_NOTICE,
        WIZARD_SIZE_LICENSE_COMPONENT,
        WIZARD_SIZE_LICENSE_COMPONENT_MARGIN,
        SIZE_READYPAGE_INSTALL_BASE,
        WIZARD_SIZE_SDK_LOCATION_TOP,
        WIZARD_SIZE_SDK_LOCATION_MIDDLE,
        WIZARD_SIZE_SDK_LOCATION_BOTTOM,
        WIZARD_SIZE_SDK_LOCATION_ERROR,
        WIZARD_SIZE_DATA_LOCATION_TOP,
        WIZARD_SIZE_DATA_LOCATION_MIDDLE,
        WIZARD_SIZE_DATA_LOCATION_BOTTOM,
        WIZARD_SIZE_DATA_LOCATION_ERROR,
        WIZARD_SIZE_INSTALL_LOCATION_LABEL,
        WIZARD_SIZE_INSTALLING_LOCATION,
        WIZARD_SIZE_COMPLETED_MESSAGE_LOCATION,
        WIZARD_SIZE_INFORMATION_DIALOG,
        WIZARD_SIZE_INFORMATION_DIALOG_TITLE,
        WIZARD_SIZE_INFORMATION_DIALOG_VERSION,
        WIZARD_SIZE_INFORMATION_DIALOG_BUTTON,
        WIZARD_SIZE_MESSAGEBOX_DIALOG,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CONTENT_TEXT,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_LINE,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_OK_BUTTON,
        WIZARD_SIZE_MESSAGEBOX_DIALOG_CANCEL_BUTTON;

    }
}

