/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.core.InstallController;
import org.tizen.installer.ui.custom.UIResource;

public class InformationDialog
extends Dialog {
    private UIResource uiResource;
    private InstallController installController;

    public InformationDialog(Shell parentShell, UIResource uiResource, InstallController installController) {
        super(parentShell);
        this.setShellStyle(67616);
        this.uiResource = uiResource;
        this.installController = installController;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        container.setLayout((Layout)gridLayout);
        this.createTopComposites(container);
        this.createMiddleComposites(container);
        return container;
    }

    private void createTopComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 378;
        gd.heightHint = 60;
        container.setLayoutData((Object)gd);
        Image infoDialogTopImage = new Image((Device)parent.getDisplay(), this.uiResource.getImageStream(UIResource.UIImages.IMAGE_INFO_DIALOG_BG_TOP));
        container.setBackgroundImage(infoDialogTopImage);
    }

    private void createMiddleComposites(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 378;
        gd.heightHint = 74;
        container.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 8;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 8;
        gridLayout.marginLeft = 8;
        gridLayout.marginRight = 8;
        gridLayout.marginBottom = 8;
        container.setLayout((Layout)gridLayout);
        this.createInformationContentComposites(container);
        Button btnOK = new Button(container, 8);
        gd = new GridData(0x1000000, 4, false, false);
        gd.widthHint = 90;
        gd.heightHint = 23;
        btnOK.setLayoutData((Object)gd);
        btnOK.setText("OK");
        btnOK.setFont(this.uiResource.getFont(UIResource.UIFont.FONT_SIZE_MIDDLE));
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InformationDialog.this.okPressed();
            }
        });
    }

    private void createInformationContentComposites(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 528);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 360;
        gd.heightHint = 27;
        scrolledComposite.setLayoutData((Object)gd);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite container = new Composite((Composite)scrolledComposite, 0);
        container.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        container.setLayout((Layout)new GridLayout(1, false));
        container.setBackground(Display.getDefault().getSystemColor(1));
        parent.setRedraw(false);
        StyledText textUpMgrInfo = new StyledText(container, 16448);
        gd = new GridData(4, 4, true, false);
        textUpMgrInfo.setLayoutData((Object)gd);
        textUpMgrInfo.setFont(this.uiResource.getFont(UIResource.UIFont.FONT_SIZE_MIDDLE));
        textUpMgrInfo.setEditable(false);
        textUpMgrInfo.setEnabled(true);
        textUpMgrInfo.setCaret(null);
        textUpMgrInfo.setText(String.format("Installer Version : %s", this.installController.getVersion()));
        scrolledComposite.setContent((Control)container);
        container.setSize(container.computeSize(-1, -1));
        scrolledComposite.setMinSize(container.computeSize(-1, -1));
        parent.setRedraw(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Installation Information");
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

