/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.dialog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.util.Log;

public class ViewDetailDialog
extends Dialog {
    private static final int LICENSE_TEXT_MARGIN = 10;
    private String title;
    private File readFile;
    private String msg;
    private int swtAlign;
    private int width = 800;
    private int height = 600;
    private static final Logger logger = Log.getLogger(ViewDetailDialog.class);

    public ViewDetailDialog(Shell parentShell, String title, File readFile, String msg, int swtAlign) {
        super(parentShell);
        String[] split;
        this.setShellStyle(67616);
        this.title = title;
        this.readFile = readFile;
        this.msg = msg;
        this.swtAlign = swtAlign;
        if (msg != null && msg.length() > 0 && (split = msg.split("\n")) != null && split.length <= 10) {
            this.width = 480;
            this.height = 320;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new FillLayout());
        this.getShell().setText(this.title);
        ScrolledComposite sc = new ScrolledComposite(container, 2560);
        Composite composite = new Composite((Composite)sc, 0);
        composite.setLayout((Layout)new FillLayout(512));
        StyledText textArea = new StyledText(composite, 2 | this.swtAlign | 0x40);
        if (this.readFile != null && this.readFile.exists()) {
            StringBuilder sb = this.makeViewString(this.readFile);
            textArea.setText(sb.toString());
        } else {
            textArea.setText(this.msg);
        }
        textArea.setMargins(10, 10, 30, 10);
        textArea.setEditable(false);
        textArea.setCaret(null);
        sc.setContent((Control)composite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(composite.computeSize(this.width, -1));
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder makeViewString(File license) {
        StringBuilder sb = new StringBuilder();
        String read = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(license), "UTF-8"));
            while ((read = bufferedReader.readLine()) != null) {
                sb.append(read + "\n");
            }
        }
        catch (FileNotFoundException e) {
            logger.throwing((Throwable)e);
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.throwing((Throwable)e);
                }
            }
        }
        return sb;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Point getInitialSize() {
        return new Point(this.width, this.height);
    }
}

