/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.installer.ui.wizard;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.installer.ui.custom.UIResource;
import org.tizen.installer.ui.dialog.CustomMessageBoxDialog;
import org.tizen.installer.util.PlatformUtil;

public class UiInitializeUtil {
    private static boolean openJadkResult = false;
    private static UIResource uiResource = new UIResource();
    private static boolean JavaVersionResult = false;
    private static boolean isCorrectJavaPath = true;

    public static boolean displayOpenJDKWarningMsgBox(final Logger logger) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(shell, uiResource, "Installer", "OpenJDK is installed.\nThe Installer and Tizen Studio do not support the OpenJDK on current OS version.\n\nYou must install the Oracle JDK 8 or later.\nPlease go to 'http://www.oracle.com/technetwork/java/javase/downloads' and download a JDK.\nDo you want to visit?", CustomMessageBoxDialog.DialogType.WARNING, false);
                int ret = dialog.open();
                if (ret == 1) {
                    logger.trace("OpenJDK is installed. - User select stop to install.");
                    openJadkResult = false;
                } else {
                    logger.trace("OpenJDK is installed. - User select continue to install.");
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI("http://www.oracle.com/technetwork/java/javase/downloads"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    openJadkResult = false;
                }
                shell.dispose();
            }
        });
        return openJadkResult;
    }

    public static boolean displayJavaVersionWarningMsgBox(final Logger logger) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(shell, uiResource, "Installer", "Java Development Kit (JDK) is not installed on your computer, or the environment variables related to it are incorrect.\n\nTo use the Tizen Studio, you need to install the JDK 8 or later.\nPlease go to 'http://www.oracle.com/technetwork/java/javase/downloads' and download a JDK.\n\nDo you want to visit?", CustomMessageBoxDialog.DialogType.NOTIFY_YES, false);
                int ret = dialog.open();
                if (ret == 1) {
                    logger.trace("Installed java version is under 1.8. - User select stop to install.");
                    JavaVersionResult = false;
                } else {
                    logger.trace("Installed java version is under 1.8. - User move download url.");
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI("http://www.oracle.com/technetwork/java/javase/downloads"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    JavaVersionResult = false;
                }
                shell.dispose();
            }
        });
        return JavaVersionResult;
    }

    public static boolean checkingJava(Logger logger) {
        logger.trace("Checking java");
        boolean result = false;
        if (PlatformUtil.isInstalledOpenJDK()) {
            logger.trace("OpenJDK is installed.");
            if (PlatformUtil.isAvailOpenJDK()) {
                logger.trace("OpenJDK available.");
                result = true;
            } else {
                logger.trace("Do not using OpenJDK.");
                result = UiInitializeUtil.displayOpenJDKWarningMsgBox(logger);
            }
        } else {
            logger.trace("Current java is working java - not open jdk");
            result = true;
        }
        if (!result) {
            return result;
        }
        if (PlatformUtil.isUnderJava8(logger)) {
            logger.trace("Installed java version is under 1.8.");
            result = UiInitializeUtil.displayJavaVersionWarningMsgBox(logger);
        } else {
            logger.trace("Current java is working java version - not java 1.8");
            result = true;
        }
        return result;
    }

    public static boolean displayJavaPathIncorrectWarningMsgBox(final String correctJavaSystemPath, Logger logger) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                CustomMessageBoxDialog dialog = new CustomMessageBoxDialog(shell, uiResource, "Installer", correctJavaSystemPath, CustomMessageBoxDialog.DialogType.NOTIFY_YES, false);
                int ret = dialog.open();
                if (ret == 1) {
                    isCorrectJavaPath = false;
                } else {
                    isCorrectJavaPath = true;
                }
                shell.dispose();
            }
        });
        return isCorrectJavaPath;
    }
}

